/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.StackMapEntry;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class StackMap
extends Attribute
implements Node {
    private int map_length;
    private StackMapEntry[] map;

    public StackMap(int n, int n2, StackMapEntry[] stackMapEntryArray, ConstantPool constantPool) {
        super((byte)11, n, n2, constantPool);
        this.setStackMap(stackMapEntryArray);
    }

    StackMap(int n, int n2, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n, n2, (StackMapEntry[])null, constantPool);
        this.map_length = dataInputStream.readUnsignedShort();
        this.map = new StackMapEntry[this.map_length];
        for (int i = 0; i < this.map_length; ++i) {
            this.map[i] = new StackMapEntry(dataInputStream, constantPool);
        }
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.map_length);
        for (int i = 0; i < this.map_length; ++i) {
            this.map[i].dump(dataOutputStream);
        }
    }

    public final StackMapEntry[] getStackMap() {
        return this.map;
    }

    public final void setStackMap(StackMapEntry[] stackMapEntryArray) {
        this.map = stackMapEntryArray;
        this.map_length = stackMapEntryArray == null ? 0 : stackMapEntryArray.length;
    }

    @Override
    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer("StackMap(");
        for (int i = 0; i < this.map_length; ++i) {
            stringBuffer.append(this.map[i].toString());
            if (i >= this.map_length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        StackMap stackMap = (StackMap)this.clone();
        stackMap.map = new StackMapEntry[this.map_length];
        for (int i = 0; i < this.map_length; ++i) {
            stackMap.map[i] = this.map[i].copy();
        }
        stackMap.constant_pool = constantPool;
        return stackMap;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitStackMap(this);
    }

    public final int getMapLength() {
        return this.map_length;
    }
}

