/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.ui.preferences.util;

import it.sogei.rcp.ui.preferences.Activator;
import it.sogei.rcp.ui.preferences.entities.PreferenceBean;
import it.sogei.rcp.ui.preferences.entities.ScopeEnum;
import it.sogei.rcp.ui.preferences.entities.priv.PreferencePageTO;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PreferencesUtilRCP {
    public static String getPreferenceValue(PreferenceBean prefBean) {
        Preferences pref = PreferencesUtilRCP.getPreferenceNode(prefBean);
        if (pref != null) {
            return pref.get(prefBean.getFieldId(), "");
        }
        return null;
    }

    public static String getPreferenceValue(PreferenceBean prefBean, ScopeEnum scope) {
        Preferences pref = PreferencesUtilRCP.getPreferenceNode(prefBean, scope);
        if (pref != null) {
            return pref.get(prefBean.getFieldId(), "");
        }
        return null;
    }

    public static String getPreferencePageFieldValue(PreferenceBean prefBean) {
        return PreferencesUtilRCP.getPreferencePageFieldValue(prefBean, false);
    }

    public static String getPreferencePageFieldValue(PreferenceBean prefBean, boolean returnDefault) {
        try {
            String fieldId = String.valueOf(prefBean.getPluginId()) + "/" + prefBean.getPrefId() + "/" + prefBean.getFieldId();
            if (PreferencesUtilRCP.isFieldInStore(Activator.getDefault().preferenceStore, fieldId, false)) {
                return Activator.getDefault().preferenceStore.getString(fieldId);
            }
            if (PreferencesUtilRCP.isFieldInStore(Activator.getDefault().preferenceStoreInstance, fieldId, false)) {
                return Activator.getDefault().preferenceStoreInstance.getString(fieldId);
            }
            if (returnDefault) {
                return Activator.getDefault().preferenceStore.getString(fieldId);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void setPreferencePageFieldValue(PreferenceBean prefBean, String fieldValue) {
        try {
            String fieldId = String.valueOf(prefBean.getPluginId()) + "/" + prefBean.getPrefId() + "/" + prefBean.getFieldId();
            PreferencePageTO prefPageTO = PreferencesUtilRCP.getPrefPageById(prefBean.getPrefId());
            if (prefPageTO != null) {
                ScopeEnum scope = prefPageTO.preferences.getScope();
                if (scope == ScopeEnum.CONFIGURATION) {
                    Activator.getDefault().preferenceStore.setValue(fieldId, fieldValue);
                } else if (scope == ScopeEnum.INSTANCE) {
                    Activator.getDefault().preferenceStoreInstance.setValue(fieldId, fieldValue);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setPreferenceValue(PreferenceBean prefBean, String fieldValue) {
        Preferences preferences = PreferencesUtilRCP.getPreferenceNode(prefBean);
        if (preferences != null) {
            preferences.put(prefBean.getFieldId(), fieldValue);
        } else {
            PreferencesUtilRCP.setInitialPreferenceValue(ScopeEnum.INSTANCE, prefBean, fieldValue);
        }
    }

    public static void setInitialPreferenceValue(ScopeEnum scope, PreferenceBean prefBean, String fieldValue) {
        IScopeContext scopeContext = PreferencesUtilRCP.createScopeIfNotExists(scope, prefBean.getPluginId());
        IEclipsePreferences preferences = scopeContext.getNode(prefBean.getPluginId());
        Preferences pref = preferences.node(prefBean.getPrefId());
        pref.put(prefBean.getFieldId(), fieldValue);
    }

    private static IScopeContext createScopeIfNotExists(ScopeEnum scope, String pluginId) {
        IScopeContext scopeContext = PreferencesUtilRCP.getScope(scope);
        if (scopeContext.getNode(pluginId) == null) {
            new ScopedPreferenceStore(scopeContext, pluginId);
        }
        return scopeContext;
    }

    private static IScopeContext getScope(ScopeEnum scope) {
        ConfigurationScope scopeContext;
        switch (scope) {
            case CONFIGURATION: {
                scopeContext = new ConfigurationScope();
                break;
            }
            case INSTANCE: {
                scopeContext = new InstanceScope();
                break;
            }
            case DEFAULT: {
                scopeContext = new DefaultScope();
                break;
            }
            default: {
                scopeContext = new DefaultScope();
            }
        }
        return scopeContext;
    }

    private static Preferences getPreferenceNode(PreferenceBean prefBean, ScopeEnum scope) {
        IEclipsePreferences preferences = PreferencesUtilRCP.getScope(scope).getNode(prefBean.getPluginId());
        if (preferences != null) {
            try {
                if (preferences.nodeExists(prefBean.getPrefId())) {
                    return preferences.node(prefBean.getPrefId());
                }
            }
            catch (BackingStoreException backingStoreException) {}
        }
        return null;
    }

    private static Preferences getPreferenceNode(PreferenceBean prefBean) {
        IEclipsePreferences preferences = PreferencesUtilRCP.getScope(ScopeEnum.INSTANCE).getNode(prefBean.getPluginId());
        if (preferences != null) {
            try {
                if (preferences.nodeExists(prefBean.getPrefId())) {
                    return preferences.node(prefBean.getPrefId());
                }
            }
            catch (BackingStoreException backingStoreException) {}
        }
        if ((preferences = PreferencesUtilRCP.getScope(ScopeEnum.CONFIGURATION).getNode(prefBean.getPluginId())) != null) {
            try {
                if (preferences.nodeExists(prefBean.getPrefId())) {
                    return preferences.node(prefBean.getPrefId());
                }
            }
            catch (BackingStoreException backingStoreException) {}
        }
        if ((preferences = PreferencesUtilRCP.getScope(ScopeEnum.DEFAULT).getNode(prefBean.getPluginId())) != null) {
            try {
                if (preferences.nodeExists(prefBean.getPrefId())) {
                    return preferences.node(prefBean.getPrefId());
                }
            }
            catch (BackingStoreException backingStoreException) {}
        }
        return null;
    }

    private static boolean isFieldInStore(ScopedPreferenceStore store, String name, boolean includeDefault) {
        if (name == null) {
            return false;
        }
        String fieldValue = Platform.getPreferencesService().get(name, null, (Preferences[])store.getPreferenceNodes(includeDefault));
        return fieldValue != null;
    }

    private static PreferencePageTO getPrefPageById(String prefPageId) {
        for (PreferencePageTO prefPageTO : Activator.preferencePageList) {
            if (!prefPageTO.id.equals(prefPageId)) continue;
            return prefPageTO;
        }
        for (PreferencePageTO prefPageTO : Activator.preferencePageContributionsList) {
            if (!prefPageTO.id.equals(prefPageId)) continue;
            return prefPageTO;
        }
        return null;
    }
}

