/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.studi2002.main;

import finanze.IDTE.generale2002.Diagnostici;
import finanze.IDTE.studi2002.campi.CodAttModel;
import finanze.IDTE.studi2002.campi.CodFiscModel;
import finanze.IDTE.studi2002.campi.ControlloFormaleException;
import finanze.IDTE.studi2002.campi.ProgressivoStudioModel;
import finanze.IDTE.studi2002.campi.RangeNumericModel;
import finanze.IDTE.studi2002.generale.CreaChiave;
import finanze.IDTE.studi2002.generale.MetodiUtili;
import finanze.IDTE.studi2002.main.Anomalia;
import finanze.IDTE.studi2002.posizione.Chiave;
import finanze.IDTE.studi2002.posizione.ChiaveAnnotazione;
import finanze.IDTE.studi2002.posizione.ChiaveStudio;
import finanze.IDTE.studi2002.posizione.FornituraAS;
import finanze.IDTE.studi2002.posizione.Posizione;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ModSettore {
    private Hashtable h_Studi = null;
    private Vector v_recordQ;
    private Vector v_recordR;
    private Vector v_recordS;
    private Vector v_recordT;
    private Vector v_recordU;
    private Vector v_records;
    private Vector v_studi;
    private boolean b_bancheEPoste = false;
    private boolean b_confermaErrori = false;
    private boolean b_annotazioneSeparata = false;
    private int maxLivelloErrore = 0;
    private Vector v_anomalie = null;
    private static final int initialCapacity = 1000;
    private boolean nonConforme_Q = false;
    private boolean nonConforme_S = false;
    private boolean nonConforme_U = false;
    Posizione posizione = null;
    private Vector v_test = null;
    private int cont_posizioni = 0;

    private void associaRecordST(ChiaveAnnotazione chiaveRecordQ) {
        String codiceFiscaleRecordQ = chiaveRecordQ.getCodiceFiscale();
        int i = 0;
        while (i < this.v_recordS.size()) {
            if (!codiceFiscaleRecordQ.equalsIgnoreCase(CreaChiave.getCodFisc((String)this.v_recordS.elementAt(i)))) {
                this.v_anomalie.addElement(new Anomalia(new ChiaveStudio(""), "S", "scarto", "813"));
                return;
            }
            ++i;
        }
        i = 0;
        while (i < this.v_recordT.size()) {
            if (!codiceFiscaleRecordQ.equalsIgnoreCase(CreaChiave.getCodFisc((String)this.v_recordT.elementAt(i)))) {
                this.v_anomalie.addElement(new Anomalia(new ChiaveStudio(""), "T", "scarto", "813"));
                return;
            }
            ++i;
        }
        this.verifica_ST();
    }

    private void controlla_QR() throws IllegalArgumentException {
        try {
            FornituraAS fornituraAS = new FornituraAS(this.v_studi);
            Vector v_appo_anomalie = fornituraAS.getAnomalie();
            if (v_appo_anomalie.size() > 0) {
                int i = 0;
                while (i < v_appo_anomalie.size()) {
                    this.v_anomalie.addElement((Anomalia)v_appo_anomalie.elementAt(i));
                    ++i;
                }
            }
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(iae.getMessage());
        }
    }

    private void controlla_ST() throws IllegalArgumentException {
        Enumeration enumeration = this.h_Studi.keys();
        int cont_p = 0;
        while (enumeration.hasMoreElements()) {
            String t_Reddito;
            block33: {
                this.v_studi = (Vector)this.h_Studi.get((ChiaveStudio)enumeration.nextElement());
                String codFisc_S = CreaChiave.getCodFisc((String)this.v_studi.elementAt(0));
                CodFiscModel codiceFiscaleModel = new CodFiscModel("CodiceFiscale", "Codice fiscale", true);
                try {
                    codiceFiscaleModel.setValore(codFisc_S);
                }
                catch (ControlloFormaleException controlloFormaleException) {
                    try {
                        this.v_anomalie.addElement(new Anomalia((Chiave)CreaChiave.getChiaveDoc((String)this.v_studi.elementAt(0)), "S", codiceFiscaleModel));
                    }
                    catch (ControlloFormaleException controlloFormaleException2) {}
                    this.v_studi.removeAllElements();
                    continue;
                }
                try {
                    CreaChiave.codAtt.setValore(CreaChiave.getCodAtt((String)this.v_studi.elementAt(0)));
                }
                catch (ControlloFormaleException controlloFormaleException) {
                    try {
                        this.v_anomalie.addElement(new Anomalia((Chiave)CreaChiave.getChiaveDoc((String)this.v_studi.elementAt(0)), "S", CreaChiave.codAtt));
                    }
                    catch (ControlloFormaleException controlloFormaleException3) {}
                    this.v_studi.removeAllElements();
                    continue;
                }
                ProgressivoStudioModel progStudio = new ProgressivoStudioModel("Progressivo", "Numero progressivo unita' produttiva", 2, 1L, 99L);
                try {
                    progStudio.setValore(CreaChiave.getProg((String)this.v_studi.elementAt(0)));
                }
                catch (ControlloFormaleException controlloFormaleException) {
                    try {
                        this.v_anomalie.addElement(new Anomalia((Chiave)CreaChiave.getChiaveDoc((String)this.v_studi.elementAt(0)), "S", progStudio));
                    }
                    catch (ControlloFormaleException controlloFormaleException4) {}
                    this.v_studi.removeAllElements();
                    continue;
                }
                RangeNumericModel annoModel = new RangeNumericModel("Anno", "Anno modello", 4, 2001L, 2002L);
                try {
                    annoModel.setValore(CreaChiave.getAnno((String)this.v_studi.elementAt(0)));
                }
                catch (ControlloFormaleException controlloFormaleException) {
                    try {
                        this.v_anomalie.addElement(new Anomalia((Chiave)CreaChiave.getChiaveDoc((String)this.v_studi.elementAt(0)), "S", annoModel));
                    }
                    catch (ControlloFormaleException controlloFormaleException5) {}
                    this.v_studi.removeAllElements();
                    continue;
                }
                RangeNumericModel tipoRedditoModel = null;
                t_Reddito = "";
                try {
                    String codAtt = CreaChiave.codAtt.getValue();
                    if (codAtt.equals("85141")) {
                        tipoRedditoModel = new RangeNumericModel("TipRedd", "Tipologia di reddito", 1, 1L, 2L);
                        t_Reddito = CreaChiave.getTipoRedditoSG56U((String)this.v_studi.elementAt(0));
                        tipoRedditoModel.setValore(t_Reddito);
                        break block33;
                    }
                    if (codAtt.equals("74811") || codAtt.equals("74812")) {
                        tipoRedditoModel = new RangeNumericModel("TipRedd", "Tipologia di reddito", 1, 1L, 2L);
                        t_Reddito = CreaChiave.getTipoRedditoSG74U((String)this.v_studi.elementAt(0));
                        tipoRedditoModel.setValore(t_Reddito);
                        break block33;
                    }
                    if (codAtt.equalsIgnoreCase("7420C")) {
                        tipoRedditoModel = new RangeNumericModel("TipRedd", "Tipologia di reddito", 1, 1L, 2L);
                        t_Reddito = CreaChiave.getTipoRedditoSK08U((String)this.v_studi.elementAt(0));
                        tipoRedditoModel.setValore(t_Reddito);
                        break block33;
                    }
                    if (codAtt.equals("70320")) {
                        tipoRedditoModel = new RangeNumericModel("TipRedd", "Tipologia di reddito", 1, 1L, 2L);
                        t_Reddito = CreaChiave.getTipoRedditoSK16U((String)this.v_studi.elementAt(0));
                        tipoRedditoModel.setValore(t_Reddito);
                        break block33;
                    }
                    if (codAtt.equals("85130")) {
                        tipoRedditoModel = new RangeNumericModel("TipRedd", "Tipologia di reddito", 1, 1L, 2L);
                        t_Reddito = CreaChiave.getTipoRedditoSK21U((String)this.v_studi.elementAt(0));
                        tipoRedditoModel.setValore(t_Reddito);
                        break block33;
                    }
                    if (codAtt.equals("63401") || codAtt.equals("63402") || codAtt.equals("64120")) {
                        tipoRedditoModel = new RangeNumericModel("TipRedd", "Tipologia di reddito", 1, 1L, 2L);
                        t_Reddito = CreaChiave.getTipoRedditoSG73B((String)this.v_studi.elementAt(0));
                        tipoRedditoModel.setValore(t_Reddito);
                        break block33;
                    }
                    if (!codAtt.equals("8514A") && !codAtt.equals("8514B") && !codAtt.equals("8514C") && !codAtt.equals("8514D")) break block33;
                    tipoRedditoModel = new RangeNumericModel("TipRedd", "Tipologia di reddito", 1, 1L, 2L);
                    t_Reddito = CreaChiave.getTipoRedditoSK19U((String)this.v_studi.elementAt(0));
                    tipoRedditoModel.setValore(t_Reddito);
                }
                catch (ControlloFormaleException controlloFormaleException) {
                    try {
                        this.v_anomalie.addElement(new Anomalia((Chiave)CreaChiave.getChiaveDoc((String)this.v_studi.elementAt(0)), "S", tipoRedditoModel));
                    }
                    catch (ControlloFormaleException controlloFormaleException6) {}
                    this.v_studi.removeAllElements();
                    continue;
                }
            }
            try {
                ChiaveStudio key_studio = CreaChiave.getChiaveDoc((String)this.v_studi.elementAt(0));
                if (!t_Reddito.equals("")) {
                    key_studio.setTipoReddito(Integer.parseInt(t_Reddito));
                }
                this.posizione = new Posizione(key_studio, "S");
                this.posizione.leggiRecords(this.v_studi);
                Vector v_appo_anomalie = this.posizione.getMessaggioErrore();
                if (v_appo_anomalie.size() > 0) {
                    int i = 0;
                    while (i < v_appo_anomalie.size()) {
                        this.v_anomalie.addElement((Anomalia)v_appo_anomalie.elementAt(i));
                        ++i;
                    }
                }
                ++cont_p;
                this.posizione = null;
                this.v_studi.removeAllElements();
            }
            catch (ControlloFormaleException cfePosizione) {
                throw new IllegalArgumentException(cfePosizione.getMessage());
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException(iae.getMessage());
            }
        }
    }

    public int liquidaRecord(Vector records, boolean flagBanchEPoste, boolean flagConfermaErrori) throws IllegalArgumentException {
        if (records == null || records.size() == 0) {
            return 0;
        }
        this.settaValori(flagBanchEPoste, records, flagConfermaErrori);
        try {
            this.verificaStudi();
            this.verificaParametri();
            if (this.v_anomalie.size() > 0) {
                this.scriviAnomalie();
            } else {
                this.maxLivelloErrore = 0;
            }
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(iae.getMessage());
        }
        Runtime.getRuntime().gc();
        return this.maxLivelloErrore;
    }

    private boolean presenzaDatiCalcolo_R(String record) {
        return MetodiUtili.isNumericNotZero(record.substring(190, 212));
    }

    private boolean presenzaDatiCalcolo_S(String record, ChiaveStudio k_studio) {
        boolean calcolato = false;
        calcolato = k_studio.getCodiceStudio().equalsIgnoreCase("SD20U") ? MetodiUtili.isNumericNotZero(record.substring(454, 476)) : (k_studio.getCodiceStudio().equalsIgnoreCase("SD32U") ? MetodiUtili.isNumericNotZero(record.substring(434, 456)) : (k_studio.getCodiceStudio().equalsIgnoreCase("SG68U") ? MetodiUtili.isNumericNotZero(record.substring(434, 456)) : (k_studio.getCodiceStudio().equalsIgnoreCase("SK02U") ? MetodiUtili.isNumericNotZero(record.substring(402, 424)) : MetodiUtili.isNumericNotZero(record.substring(412, 434)))));
        if (calcolato && record.substring(1750, 1751).equals("0")) {
            calcolato = k_studio.getCodiceStudio().equalsIgnoreCase("SG68U") ? MetodiUtili.isNumericNotZero(record.substring(757, 836)) : (k_studio.getCodiceStudio().equalsIgnoreCase("SK01U") ? MetodiUtili.isNumericNotZero(record.substring(838, 865)) : (k_studio.getCodiceStudio().equalsIgnoreCase("SK02U") ? MetodiUtili.isNumericNotZero(record.substring(745, 836)) : (k_studio.getCodiceStudio().equalsIgnoreCase("SK08U") ? MetodiUtili.isNumericNotZero(record.substring(757, 836)) : MetodiUtili.isNumericNotZero(record.substring(755, 836)))));
        }
        return calcolato;
    }

    private void scriviAnomalie() throws IllegalArgumentException {
        new StringBuffer(1000);
        int gravitaErrore = 0;
        String appo_sb = null;
        int i = 0;
        while (i < this.v_anomalie.size()) {
            appo_sb = ((Anomalia)this.v_anomalie.elementAt(i)).getRecordDgn(this.b_bancheEPoste, this.b_confermaErrori);
            if (!appo_sb.equals("")) {
                gravitaErrore = ((Anomalia)this.v_anomalie.elementAt(i)).getGravitaErrore();
                if (gravitaErrore > this.maxLivelloErrore) {
                    this.maxLivelloErrore = gravitaErrore;
                }
                if (gravitaErrore == 8 || gravitaErrore >= 14) {
                    ++Diagnostici.numeroErroriRicevute;
                }
                Diagnostici.scriviDiagnostici(appo_sb);
            }
            appo_sb = null;
            ++i;
        }
    }

    private void settaValori(boolean flagBanchEPoste, Vector records, boolean flagConfermaErrori) {
        this.b_bancheEPoste = flagBanchEPoste;
        this.b_confermaErrori = flagConfermaErrori;
        this.maxLivelloErrore = 0;
        this.v_records = records;
        this.v_anomalie = new Vector();
        this.v_studi = new Vector();
        this.v_recordQ = new Vector();
        this.v_recordR = new Vector();
        this.v_recordS = new Vector();
        this.v_recordT = new Vector();
        this.v_recordU = new Vector();
        this.v_test = new Vector();
        int i = 0;
        while (i < this.v_records.size()) {
            String record = (String)this.v_records.elementAt(i);
            char tipoRecord = record.charAt(0);
            switch (tipoRecord) {
                case 'Q': {
                    this.v_recordQ.addElement(record);
                    break;
                }
                case 'R': {
                    this.v_recordR.addElement(record);
                    break;
                }
                case 'S': {
                    this.v_recordS.addElement(record);
                    this.v_test.addElement(record);
                    break;
                }
                case 'T': {
                    this.v_recordT.addElement(record);
                    break;
                }
                case 'U': {
                    this.v_recordU.addElement(record);
                    break;
                }
            }
            ++i;
        }
    }

    private void verifica_QR() {
        ChiaveAnnotazione chiaveRecordQ = null;
        ChiaveAnnotazione chiaveRecordR = null;
        if (this.v_recordQ.size() == 0 && this.v_recordR.size() > 0) {
            this.v_anomalie.addElement(new Anomalia(new ChiaveStudio(CreaChiave.getCodFisc((String)this.v_recordR.elementAt(0))), "Q", "scarto", "803"));
        }
        if (this.v_recordQ.size() > 0 && this.v_recordR.size() == 0) {
            this.v_anomalie.addElement(new Anomalia(new ChiaveStudio(CreaChiave.getCodFisc((String)this.v_recordQ.elementAt(0))), "R", "scarto", "803"));
        }
        if (this.v_recordQ.size() > 1) {
            this.v_anomalie.addElement(new Anomalia(new ChiaveStudio(CreaChiave.getCodFisc((String)this.v_recordQ.elementAt(0))), "Q", "scarto", "804"));
        }
        if (this.v_recordR.size() > 1) {
            this.v_anomalie.addElement(new Anomalia(new ChiaveStudio(CreaChiave.getCodFisc((String)this.v_recordR.elementAt(0))), "R", "scarto", "804"));
        }
        if (this.v_anomalie.size() > 0) {
            return;
        }
        try {
            chiaveRecordQ = CreaChiave.getChiaveDocAS(this.v_recordQ.elementAt(0).toString(), this.v_recordQ.elementAt(0).toString().substring(0, 1));
        }
        catch (ControlloFormaleException controlloFormaleException) {
            this.v_anomalie.addElement((Anomalia)CreaChiave.getAnomalie().elementAt(0));
        }
        try {
            chiaveRecordR = CreaChiave.getChiaveDocAS(this.v_recordR.elementAt(0).toString(), this.v_recordR.elementAt(0).toString().substring(0, 1));
        }
        catch (ControlloFormaleException controlloFormaleException) {
            this.v_anomalie.addElement((Anomalia)CreaChiave.getAnomalie().elementAt(0));
        }
        if (this.v_anomalie.size() > 0) {
            return;
        }
        if (!chiaveRecordQ.equals(chiaveRecordR)) {
            this.v_anomalie.addElement(new Anomalia(chiaveRecordR, "R", "scarto", "812"));
        }
        this.associaRecordST(chiaveRecordQ);
        if (this.v_anomalie.size() == 0) {
            this.v_studi.addElement((String)this.v_recordQ.elementAt(0));
            this.v_studi.addElement((String)this.v_recordR.elementAt(0));
            if (!this.h_Studi.isEmpty()) {
                Enumeration e = this.h_Studi.elements();
                while (e.hasMoreElements()) {
                    Vector v = (Vector)e.nextElement();
                    int i = 0;
                    while (i < v.size()) {
                        this.v_studi.addElement((String)v.elementAt(i));
                        ++i;
                    }
                }
            }
        }
    }

    private void verifica_ST() throws IllegalArgumentException {
        block27: {
            Hashtable<ChiaveStudio, String> errori = new Hashtable<ChiaveStudio, String>();
            this.cont_posizioni = 0;
            try {
                if (this.v_recordS.size() == 0 && this.v_recordT.size() > 0) {
                    int i = 0;
                    while (i < this.v_recordT.size()) {
                        try {
                            errori.put(CreaChiave.getChiaveDoc((String)this.v_recordT.elementAt(i)), "scarto");
                        }
                        catch (ControlloFormaleException controlloFormaleException) {
                            this.v_anomalie.addElement((Anomalia)CreaChiave.getAnomalie().elementAt(0));
                        }
                        ++i;
                    }
                    Enumeration enumeration = errori.keys();
                    while (enumeration.hasMoreElements()) {
                        this.v_anomalie.addElement(new Anomalia((ChiaveStudio)enumeration.nextElement(), "S", "scarto", "803"));
                    }
                    return;
                }
                if (this.v_recordT.size() == 0 && this.v_recordS.size() > 0) {
                    int i = 0;
                    while (i < this.v_recordS.size()) {
                        try {
                            errori.put(CreaChiave.getChiaveDoc((String)this.v_recordS.elementAt(i)), "scarto");
                        }
                        catch (ControlloFormaleException controlloFormaleException) {
                            this.v_anomalie.addElement((Anomalia)CreaChiave.getAnomalie().elementAt(0));
                        }
                        ++i;
                    }
                    Enumeration enumeration = errori.keys();
                    while (enumeration.hasMoreElements()) {
                        this.v_anomalie.addElement(new Anomalia((ChiaveStudio)enumeration.nextElement(), "T", "scarto", "803"));
                    }
                    return;
                }
                ChiaveStudio chiave = null;
                ChiaveStudio chiaveRecordT = null;
                Vector<String> v_Studi = new Vector<String>();
                this.h_Studi = new Hashtable();
                int i = 0;
                while (i < this.v_recordS.size()) {
                    v_Studi.addElement((String)this.v_recordS.elementAt(i));
                    try {
                        chiave = CreaChiave.getChiaveDoc((String)this.v_recordS.elementAt(i));
                    }
                    catch (ControlloFormaleException controlloFormaleException) {
                        this.v_anomalie.addElement((Anomalia)CreaChiave.getAnomalie().elementAt(0));
                        this.v_recordS.removeElementAt(i);
                        v_Studi.removeElementAt(i);
                        continue;
                    }
                    this.v_recordS.removeElementAt(i);
                    int j = 0;
                    while (j < this.v_recordT.size()) {
                        block26: {
                            block25: {
                                try {
                                    chiaveRecordT = CreaChiave.getChiaveDoc((String)this.v_recordT.elementAt(j));
                                    if (!chiave.equals(chiaveRecordT)) break block25;
                                    v_Studi.addElement((String)this.v_recordT.elementAt(j));
                                    this.v_recordT.removeElementAt(j);
                                    --j;
                                }
                                catch (ControlloFormaleException controlloFormaleException) {
                                    this.v_anomalie.addElement((Anomalia)CreaChiave.getAnomalie().elementAt(0));
                                    this.v_recordT.removeElementAt(j);
                                    --j;
                                    break block26;
                                }
                            }
                            chiaveRecordT = null;
                        }
                        ++j;
                    }
                    if (v_Studi.size() == 1) {
                        Enumeration e = this.h_Studi.keys();
                        boolean chiave_Hstudi_S = false;
                        while (e.hasMoreElements()) {
                            if (!chiave.equals((ChiaveStudio)e.nextElement())) continue;
                            this.v_anomalie.addElement(new Anomalia(chiave, "S", "scarto", "804"));
                            chiave_Hstudi_S = true;
                        }
                        if (!chiave_Hstudi_S) {
                            this.v_anomalie.addElement(new Anomalia(chiave, "T", "scarto", "803"));
                        }
                        v_Studi.removeElementAt(i);
                        continue;
                    }
                    Vector<String> v_Appo = new Vector<String>();
                    int k = 0;
                    while (k < v_Studi.size()) {
                        v_Appo.addElement((String)v_Studi.elementAt(k));
                        ++k;
                    }
                    this.h_Studi.put(chiave, v_Appo);
                    ++this.cont_posizioni;
                    v_Studi.removeAllElements();
                    chiave = null;
                }
                if (this.v_recordT.size() <= 0) break block27;
                i = 0;
                while (i < this.v_recordT.size()) {
                    try {
                        this.v_anomalie.addElement(new Anomalia(CreaChiave.getChiaveDoc((String)this.v_recordT.elementAt(i)), "S", "scarto", "803"));
                    }
                    catch (ControlloFormaleException controlloFormaleException) {
                        this.v_anomalie.addElement((Anomalia)CreaChiave.getAnomalie().elementAt(0));
                    }
                    ++i;
                }
                return;
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException(iae.getMessage());
            }
        }
    }

    private void verificaParametri() throws IllegalArgumentException {
        if (this.v_recordU.size() == 0) {
            return;
        }
        String codFiscale = null;
        Vector<String> v_Parametri = new Vector<String>();
        int i = 0;
        while (i < this.v_recordU.size()) {
            block13: {
                v_Parametri.addElement((String)this.v_recordU.elementAt(i));
                codFiscale = CreaChiave.getCodFisc((String)v_Parametri.elementAt(0));
                this.nonConforme_U = CreaChiave.getFlagNonConformita_U((String)v_Parametri.elementAt(0));
                CodFiscModel cfm = new CodFiscModel("CodiceFiscale", "Codice fiscale", true);
                try {
                    cfm.setValore(codFiscale);
                }
                catch (ControlloFormaleException controlloFormaleException) {
                    this.v_anomalie.addElement(new Anomalia((Chiave)new ChiaveStudio(codFiscale, CreaChiave.getCodAtt((String)v_Parametri.elementAt(0))), "U", cfm));
                    v_Parametri.removeAllElements();
                    codFiscale = null;
                    break block13;
                }
                CodAttModel codiceAtt = null;
                try {
                    codiceAtt = new CodAttModel("CodiceAttivita", "Codice attivita'", "U");
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException(iae.getMessage());
                }
                try {
                    codiceAtt.setValore(CreaChiave.getCodAtt((String)v_Parametri.elementAt(0)));
                }
                catch (ControlloFormaleException controlloFormaleException) {
                    this.v_anomalie.addElement(new Anomalia((Chiave)new ChiaveStudio(codFiscale, CreaChiave.getCodAtt((String)v_Parametri.elementAt(0))), "U", codiceAtt));
                    v_Parametri.removeAllElements();
                    codFiscale = null;
                    break block13;
                }
                RangeNumericModel tipoContribuente = new RangeNumericModel("TipoContribuente", "Tipologia del contribuente", 1, 1L, 2L);
                try {
                    tipoContribuente.setValore(CreaChiave.getTipologiaContribuente((String)v_Parametri.elementAt(0)));
                }
                catch (ControlloFormaleException controlloFormaleException) {
                    this.v_anomalie.addElement(new Anomalia((Chiave)new ChiaveStudio(codFiscale, CreaChiave.getCodAtt((String)v_Parametri.elementAt(0))), "U", tipoContribuente));
                    v_Parametri.removeAllElements();
                    codFiscale = null;
                    break block13;
                }
                if ((codiceAtt.getTipologia().equals("1") || codiceAtt.getTipologia().equals("2")) && !codiceAtt.getTipologia().equals(tipoContribuente.getValue())) {
                    this.v_anomalie.addElement(new Anomalia(new ChiaveStudio(codFiscale, CreaChiave.getCodAtt((String)v_Parametri.elementAt(0))), "U", "anomalia", "811"));
                }
                ChiaveStudio chiaveParametri = new ChiaveStudio(codFiscale, CreaChiave.getCodAtt((String)v_Parametri.elementAt(0)));
                chiaveParametri.setTipoReddito(Integer.parseInt(CreaChiave.getTipologiaContribuente((String)v_Parametri.elementAt(0))));
                this.posizione = new Posizione(chiaveParametri, "U");
                this.posizione.leggiRecords(v_Parametri);
                ++this.cont_posizioni;
                Vector v_appo_anomalie = this.posizione.getMessaggioErrore();
                if (v_appo_anomalie.size() > 0) {
                    int j = 0;
                    while (j < v_appo_anomalie.size()) {
                        this.v_anomalie.addElement((Anomalia)v_appo_anomalie.elementAt(j));
                        ++j;
                    }
                }
                v_Parametri.removeAllElements();
                codFiscale = null;
                this.posizione = null;
            }
            ++i;
        }
    }

    private void verificaStudi() throws IllegalArgumentException {
        if (this.v_recordQ.size() > 0 || this.v_recordR.size() > 0 || this.v_recordS.size() > 0 || this.v_recordT.size() > 0) {
            if (this.v_recordQ.size() > 0 || this.v_recordR.size() > 0) {
                this.verifica_QR();
                if (this.v_anomalie.size() > 0) {
                    return;
                }
                this.b_annotazioneSeparata = true;
            } else if (this.v_recordS.size() > 0 || this.v_recordT.size() > 0) {
                this.verifica_ST();
                if (this.v_anomalie.size() > 0) {
                    return;
                }
                this.h_Studi.isEmpty();
            } else {
                return;
            }
            if (!this.b_annotazioneSeparata && !this.h_Studi.isEmpty()) {
                this.controlla_ST();
            }
            if (this.b_annotazioneSeparata) {
                this.controlla_QR();
            }
            return;
        }
    }
}

