/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ecc.math.algorithms;

import iaik.security.ecc.math.algorithms.AlgorithmException;
import iaik.security.ecc.math.field.BinaryField;
import iaik.security.ecc.math.field.Constants;
import iaik.security.ecc.math.field.FieldElement;
import iaik.security.ecc.math.field.PrimeField;
import java.math.BigInteger;
import java.util.Random;

public class SquareRoot {
    private SquareRoot() {
    }

    public static BigInteger[] lucasSeq(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws AlgorithmException {
        if (Constants.BIG_ONE.compareTo(bigInteger3) != -1) {
            throw new AlgorithmException("SquareRoot.2");
        }
        BigInteger bigInteger5 = Constants.BIG_TWO;
        BigInteger bigInteger6 = bigInteger;
        BigInteger bigInteger7 = Constants.BIG_ONE;
        BigInteger bigInteger8 = Constants.BIG_ONE;
        byte[] byArray = bigInteger3.toByteArray();
        int n = bigInteger3.bitLength();
        int n2 = 0;
        if (byArray[0] == 0) {
            ++n2;
        }
        int n3 = 1 << (n & 7) - 1;
        int n4 = n;
        while (n4 > 0) {
            bigInteger7 = bigInteger7.multiply(bigInteger8).mod(bigInteger4);
            if ((byArray[n2] & n3) != 0) {
                bigInteger8 = bigInteger7.multiply(bigInteger2).mod(bigInteger4);
                bigInteger5 = bigInteger5.multiply(bigInteger6).subtract(bigInteger.multiply(bigInteger7)).mod(bigInteger4);
                bigInteger6 = bigInteger6.pow(2).subtract(bigInteger8.shiftLeft(1)).mod(bigInteger4);
            } else {
                bigInteger8 = bigInteger7;
                bigInteger6 = bigInteger5.multiply(bigInteger6).subtract(bigInteger.multiply(bigInteger7)).mod(bigInteger4);
                bigInteger5 = bigInteger5.pow(2).subtract(bigInteger7.shiftLeft(1)).mod(bigInteger4);
            }
            if ((n3 >>>= 1) == 0) {
                ++n2;
                n3 = 128;
            }
            --n4;
        }
        return new BigInteger[]{bigInteger5, bigInteger7};
    }

    public static FieldElement calcSQRT(FieldElement fieldElement) throws AlgorithmException {
        switch (fieldElement.getField().getFieldId()) {
            case 1: {
                return SquareRoot.GFP_SQRT(fieldElement);
            }
            case 2: {
                return SquareRoot.G2N_SQRT(fieldElement);
            }
        }
        throw new AlgorithmException("SquareRoot.1");
    }

    private static FieldElement G2N_SQRT(FieldElement fieldElement) {
        BinaryField binaryField = (BinaryField)fieldElement.getField();
        byte[] byArray = new byte[]{0};
        int n = binaryField.getOrder();
        int n2 = n >>> 3;
        int n3 = n & 7;
        if (n3 != 0) {
            ++n2;
        }
        Random random = new Random();
        FieldElement fieldElement2 = null;
        FieldElement fieldElement3 = null;
        do {
            byte[] byArray2 = new byte[n2];
            random.nextBytes(byArray2);
            byArray2[0] = (byte)(byArray2[0] & 255 >>> (8 - n3 & 7));
            FieldElement fieldElement4 = binaryField.newElement(byArray2);
            fieldElement2 = binaryField.newElement(byArray);
            FieldElement fieldElement5 = (FieldElement)fieldElement.clone();
            int n4 = 1;
            while (n4 < n) {
                fieldElement5.square();
                FieldElement fieldElement6 = FieldElement.multiply(fieldElement5, fieldElement4);
                fieldElement2.square().add(fieldElement6);
                fieldElement5.add(fieldElement);
                ++n4;
            }
            if (!fieldElement5.isZero()) {
                return null;
            }
            fieldElement3 = FieldElement.square(fieldElement2);
            fieldElement3.add(fieldElement2);
        } while (fieldElement3.isZero());
        return fieldElement2;
    }

    private static FieldElement GFP_SQRT(FieldElement fieldElement) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = fieldElement.toBigInt();
        BigInteger bigInteger3 = SquareRoot.sqrt(bigInteger2, bigInteger = fieldElement.getField().getSize());
        if (bigInteger3 == null) {
            return null;
        }
        return ((PrimeField)fieldElement.getField()).newElement(bigInteger3);
    }

    private static BigInteger sqrt(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger[] bigIntegerArray = bigInteger2.divideAndRemainder(Constants.BIG_FOUR);
        if (bigIntegerArray[1].equals(Constants.BIG_THREE)) {
            BigInteger bigInteger3 = bigInteger.modPow(bigIntegerArray[0].add(Constants.BIG_ONE), bigInteger2);
            if (bigInteger3.multiply(bigInteger3).mod(bigInteger2).equals(bigInteger)) {
                return bigInteger3;
            }
            return null;
        }
        bigIntegerArray = bigInteger2.divideAndRemainder(Constants.BIG_EIGHT);
        if (bigIntegerArray[1].equals(Constants.BIG_FIVE)) {
            BigInteger bigInteger4 = bigInteger.shiftLeft(1).modPow(bigIntegerArray[0], bigInteger2);
            BigInteger bigInteger5 = bigInteger4.multiply(bigInteger4).mod(bigInteger2).multiply(bigInteger).shiftLeft(1).mod(bigInteger2);
            BigInteger bigInteger6 = bigInteger5.subtract(Constants.BIG_ONE).multiply(bigInteger).mod(bigInteger2).multiply(bigInteger4).mod(bigInteger2);
            if (bigInteger6.multiply(bigInteger6).mod(bigInteger2).equals(bigInteger)) {
                return bigInteger6;
            }
            return null;
        }
        if (bigIntegerArray[1].equals(Constants.BIG_ONE)) {
            BigInteger bigInteger7 = bigInteger;
            BigInteger bigInteger8 = bigInteger2.add(Constants.BIG_ONE).shiftRight(1);
            BigInteger[] bigIntegerArray2 = null;
            Random random = new Random();
            do {
                BigInteger bigInteger9 = new BigInteger(bigInteger2.bitLength(), random);
                bigInteger9 = bigInteger9.mod(bigInteger2);
                try {
                    bigIntegerArray2 = SquareRoot.lucasSeq(bigInteger9, bigInteger7, bigInteger8, bigInteger2);
                }
                catch (AlgorithmException algorithmException) {
                    return null;
                }
                BigInteger bigInteger10 = null;
                bigInteger10 = bigIntegerArray2[0].testBit(0) ? bigIntegerArray2[0].add(bigInteger2).mod(bigInteger2).shiftRight(1).mod(bigInteger2) : bigIntegerArray2[0].shiftRight(1).mod(bigInteger2);
                if (!bigInteger10.multiply(bigInteger10).mod(bigInteger2).equals(bigInteger)) continue;
                return bigInteger10;
            } while (bigIntegerArray2[1].compareTo(Constants.BIG_ONE) != 1 || bigIntegerArray2[1].compareTo(bigInteger2.subtract(Constants.BIG_ONE)) != -1);
            return null;
        }
        return null;
    }
}

