/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.patch.InputPatchPage;
import org.eclipse.compare.internal.patch.PatchMessages;
import org.eclipse.compare.internal.patch.PatchWizard;
import org.eclipse.compare.internal.patch.PreviewPatchPage2;
import org.eclipse.compare.internal.patch.WorkspacePatcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class PatchTargetPage
extends WizardPage {
    private boolean fShowError = false;
    private TreeViewer fPatchTargets;
    private Button useWorkspaceAsTarget;
    private Button selectTarget;
    protected WorkspacePatcher fPatcher;
    protected static final String PATCHTARGETPAGE_NAME = "PatchTargetPage";

    public PatchTargetPage(WorkspacePatcher patcher) {
        super(PATCHTARGETPAGE_NAME, PatchMessages.PatchTargetPage_title, null);
        this.setMessage(PatchMessages.PatchTargetPage_message);
        this.fPatcher = patcher;
    }

    protected IPath getPathFromText(Text textField) {
        return new Path(textField.getText()).makeAbsolute();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.setControl((Control)composite);
        this.useWorkspaceAsTarget = this.createRadioButton(composite, PatchMessages.PatchTargetPage_0, 1);
        this.selectTarget = this.createRadioButton(composite, PatchMessages.InputPatchPage_SelectInput, 1);
        this.buildInputGroup(composite);
        this.updateWidgetEnablements();
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.compare.patch_input_wizard_page_context");
        this.useWorkspaceAsTarget.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PatchTargetPage.this.fShowError = true;
                if (PatchTargetPage.this.useWorkspaceAsTarget.getSelection()) {
                    PatchTargetPage.this.fPatchTargets.getTree().setEnabled(false);
                    PatchTargetPage.this.fPatcher.setTarget((IResource)ResourcesPlugin.getWorkspace().getRoot());
                } else {
                    PatchTargetPage.this.fPatchTargets.getTree().setEnabled(true);
                    PatchTargetPage.this.fPatcher.setTarget(Utilities.getFirstResource(PatchTargetPage.this.fPatchTargets.getSelection()));
                }
                PatchTargetPage.this.markPreviewPageToRecalucateIfNonWorkspacePatch();
                PatchTargetPage.this.updateWidgetEnablements();
            }
        });
    }

    private void markPreviewPageToRecalucateIfNonWorkspacePatch() {
        if (!this.fPatcher.isWorkspacePatch()) {
            PreviewPatchPage2 previewPage = (PreviewPatchPage2)this.getWizard().getPage("PreviewPatchPage");
            previewPage.pageRecalculate = true;
        }
    }

    private Button createRadioButton(Composite parent, String label, int span) {
        Button button = new Button(parent, 16);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalSpan = span;
        button.setLayoutData((Object)data);
        return button;
    }

    public IWizardPage getNextPage() {
        if (!this.fPatcher.isWorkspacePatch() && this.fPatcher.getTarget() instanceof IFile && this.fPatcher.getDiffs().length > 1) {
            InputPatchPage inputPage = (InputPatchPage)this.getWizard().getPage("InputPatchPage");
            String source = "";
            switch (inputPage.getInputMethod()) {
                case 1: {
                    source = PatchMessages.InputPatchPage_Clipboard_title;
                    break;
                }
                case 2: {
                    source = PatchMessages.InputPatchPage_PatchFile_title;
                    break;
                }
                case 3: {
                    source = PatchMessages.InputPatchPage_WorkspacePatch_title;
                }
            }
            String format = PatchMessages.InputPatchPage_SingleFileError_format;
            String message = MessageFormat.format((String)format, (Object[])new String[]{source});
            MessageDialog.openInformation(null, (String)PatchMessages.InputPatchPage_PatchErrorDialog_title, (String)message);
            return this;
        }
        return super.getNextPage();
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    private void buildInputGroup(Composite parent) {
        Tree tree = new Tree(parent, 2048);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        tree.setLayoutData((Object)gd);
        this.fPatchTargets = new TreeViewer(tree);
        this.fPatchTargets.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.fPatchTargets.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.fPatchTargets.setComparator((ViewerComparator)new ResourceComparator(1));
        this.fPatchTargets.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        IResource target = this.fPatcher.getTarget();
        if (target != null && !(target instanceof IWorkspaceRoot)) {
            this.fPatchTargets.expandToLevel((Object)target, 0);
            this.fPatchTargets.setSelection((ISelection)new StructuredSelection((Object)target));
        }
        this.fPatchTargets.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PatchTargetPage.this.fShowError = true;
                PatchTargetPage.this.fPatcher.setTarget(Utilities.getFirstResource(event.getSelection()));
                PatchTargetPage.this.updateWidgetEnablements();
            }
        });
        this.fPatchTargets.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ((PatchWizard)PatchTargetPage.this.getWizard()).showPage(PatchTargetPage.this.getNextPage());
            }
        });
    }

    private void updateWidgetEnablements() {
        String error = null;
        if (this.fPatcher.getTarget() == null) {
            this.useWorkspaceAsTarget.setSelection(false);
            this.selectTarget.setSelection(true);
            error = PatchMessages.InputPatchPage_NothingSelected_message;
            this.setPageComplete(false);
            if (this.fShowError) {
                this.setErrorMessage(error);
            }
            return;
        }
        this.setErrorMessage(null);
        this.useWorkspaceAsTarget.setSelection(this.fPatcher.getTarget() instanceof IWorkspaceRoot);
        this.selectTarget.setSelection(!this.useWorkspaceAsTarget.getSelection());
        this.setPageComplete(true);
    }

    public boolean finish() {
        return true;
    }
}

