/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.addressing;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.addressing.WsaPropertyBag;
import com.sun.xml.internal.ws.addressing.WsaTube;
import com.sun.xml.internal.ws.addressing.model.ActionNotSupportedException;
import com.sun.xml.internal.ws.addressing.model.InvalidAddressingHeaderException;
import com.sun.xml.internal.ws.api.EndpointAddress;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.WSService;
import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.message.HeaderList;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Messages;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.internal.ws.api.pipe.Fiber;
import com.sun.xml.internal.ws.api.pipe.NextAction;
import com.sun.xml.internal.ws.api.pipe.TransportTubeFactory;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.message.FaultDetailHeader;
import com.sun.xml.internal.ws.resources.AddressingMessages;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.WebServiceException;

public class WsaServerTube
extends WsaTube {
    private WSEndpoint endpoint;
    private WSEndpointReference replyTo;
    private WSEndpointReference faultTo;
    private boolean isAnonymousRequired = false;
    private WSDLBoundOperation wbo;
    public static final String REQUEST_MESSAGE_ID = "com.sun.xml.internal.ws.addressing.request.messageID";
    private static final Logger LOGGER = Logger.getLogger(WsaServerTube.class.getName());

    public WsaServerTube(WSEndpoint wSEndpoint, @NotNull WSDLPort wSDLPort, WSBinding wSBinding, Tube tube) {
        super(wSDLPort, wSBinding, tube);
        this.endpoint = wSEndpoint;
    }

    public WsaServerTube(WsaServerTube wsaServerTube, TubeCloner tubeCloner) {
        super(wsaServerTube, tubeCloner);
        this.endpoint = wsaServerTube.endpoint;
    }

    @Override
    public WsaServerTube copy(TubeCloner tubeCloner) {
        return new WsaServerTube(this, tubeCloner);
    }

    @Override
    @NotNull
    public NextAction processRequest(Packet packet) {
        Message message = packet.getMessage();
        if (message == null) {
            return this.doInvoke(this.next, packet);
        }
        packet.addSatellite(new WsaPropertyBag(this.addressingVersion, this.soapVersion, packet));
        HeaderList headerList = packet.getMessage().getHeaders();
        try {
            this.replyTo = headerList.getReplyTo(this.addressingVersion, this.soapVersion);
            this.faultTo = headerList.getFaultTo(this.addressingVersion, this.soapVersion);
        }
        catch (InvalidAddressingHeaderException invalidAddressingHeaderException) {
            Object object;
            LOGGER.log(Level.WARNING, this.addressingVersion.getInvalidMapText() + ", Problem header:" + invalidAddressingHeaderException.getProblemHeader() + ", Reason: " + invalidAddressingHeaderException.getSubsubcode(), invalidAddressingHeaderException);
            SOAPFault sOAPFault = this.helper.createInvalidAddressingHeaderFault(invalidAddressingHeaderException, this.addressingVersion);
            if (this.wsdlPort != null && packet.getMessage().isOneWay(this.wsdlPort)) {
                Packet packet2 = packet.createServerResponse(null, this.wsdlPort, null, this.binding);
                return this.doReturnWith(packet2);
            }
            Message message2 = Messages.create(sOAPFault);
            if (this.soapVersion == SOAPVersion.SOAP_11) {
                object = new FaultDetailHeader(this.addressingVersion, this.addressingVersion.problemHeaderQNameTag.getLocalPart(), invalidAddressingHeaderException.getProblemHeader());
                message2.getHeaders().add((Header)object);
            }
            object = packet.createServerResponse(message2, this.wsdlPort, null, this.binding);
            return this.doReturnWith((Packet)object);
        }
        if (this.replyTo == null) {
            this.replyTo = this.addressingVersion.anonymousEpr;
        }
        if (this.faultTo == null) {
            this.faultTo = this.replyTo;
        }
        this.wbo = this.getWSDLBoundOperation(packet);
        this.isAnonymousRequired = this.isAnonymousRequired(this.wbo);
        Packet packet3 = this.validateInboundHeaders(packet);
        if (packet3.getMessage() == null) {
            return this.doReturnWith(packet3);
        }
        if (packet3.getMessage().isFault()) {
            if (!this.isAnonymousRequired && !this.faultTo.isAnonymous() && packet.transportBackChannel != null) {
                packet.transportBackChannel.close();
            }
            return this.processResponse(packet3);
        }
        if (!(this.isAnonymousRequired || this.replyTo.isAnonymous() || this.faultTo.isAnonymous() || packet.transportBackChannel == null)) {
            packet.transportBackChannel.close();
        }
        return this.doInvoke(this.next, packet3);
    }

    protected boolean isAnonymousRequired(@Nullable WSDLBoundOperation wSDLBoundOperation) {
        return false;
    }

    protected void checkAnonymousSemantics(WSDLBoundOperation wSDLBoundOperation, WSEndpointReference wSEndpointReference, WSEndpointReference wSEndpointReference2) {
    }

    @Override
    @NotNull
    public NextAction processResponse(Packet packet) {
        WSEndpointReference wSEndpointReference;
        Message message = packet.getMessage();
        if (message == null) {
            return this.doReturnWith(packet);
        }
        WSEndpointReference wSEndpointReference2 = wSEndpointReference = message.isFault() ? this.faultTo : this.replyTo;
        if (wSEndpointReference.isAnonymous() || this.isAnonymousRequired) {
            return this.doReturnWith(packet);
        }
        if (wSEndpointReference.isNone()) {
            packet.setMessage(null);
            return this.doReturnWith(packet);
        }
        this.processNonAnonymousReply(packet, wSEndpointReference);
        packet.setMessage(null);
        return this.doReturnWith(packet);
    }

    private void processNonAnonymousReply(Packet packet, WSEndpointReference wSEndpointReference) {
        String string;
        EndpointAddress endpointAddress;
        if (packet.transportBackChannel != null) {
            packet.transportBackChannel.close();
        }
        if (this.wsdlPort != null && packet.getMessage().isOneWay(this.wsdlPort)) {
            LOGGER.fine(AddressingMessages.NON_ANONYMOUS_RESPONSE_ONEWAY());
            return;
        }
        try {
            endpointAddress = new EndpointAddress(URI.create(wSEndpointReference.getAddress()));
        }
        catch (NullPointerException nullPointerException) {
            throw new WebServiceException(nullPointerException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new WebServiceException(illegalArgumentException);
        }
        Tube tube = TransportTubeFactory.create(Thread.currentThread().getContextClassLoader(), new ClientTubeAssemblerContext(endpointAddress, this.wsdlPort, (WSService)null, this.binding, this.endpoint.getContainer(), ((BindingImpl)this.binding).createCodec(), null));
        packet.endpointAddress = endpointAddress;
        packet.soapAction = string = packet.getMessage().isFault() ? this.helper.getFaultAction(this.wbo, packet) : this.helper.getOutputAction(this.wbo);
        packet.expectReply = false;
        Fiber.current().runSync(tube, packet);
    }

    @Override
    protected void validateAction(Packet packet) {
        WSDLBoundOperation wSDLBoundOperation = this.getWSDLBoundOperation(packet);
        if (wSDLBoundOperation == null) {
            return;
        }
        String string = packet.getMessage().getHeaders().getAction(this.addressingVersion, this.soapVersion);
        if (string == null) {
            throw new WebServiceException(AddressingMessages.VALIDATION_SERVER_NULL_ACTION());
        }
        String string2 = this.helper.getInputAction(packet);
        String string3 = this.helper.getSOAPAction(packet);
        if (this.helper.isInputActionDefault(packet) && string3 != null && !string3.equals("")) {
            string2 = string3;
        }
        if (string2 != null && !string.equals(string2)) {
            throw new ActionNotSupportedException(string);
        }
    }

    @Override
    protected void checkMessageAddressingProperties(Packet packet) {
        super.checkMessageAddressingProperties(packet);
        WSDLBoundOperation wSDLBoundOperation = this.getWSDLBoundOperation(packet);
        this.checkAnonymousSemantics(wSDLBoundOperation, this.replyTo, this.faultTo);
        this.checkNonAnonymousAddresses(this.replyTo, this.faultTo);
    }

    private void checkNonAnonymousAddresses(WSEndpointReference wSEndpointReference, WSEndpointReference wSEndpointReference2) {
        if (!wSEndpointReference.isAnonymous()) {
            try {
                new EndpointAddress(URI.create(wSEndpointReference.getAddress()));
            }
            catch (Exception exception) {
                throw new InvalidAddressingHeaderException(this.addressingVersion.replyToTag, this.addressingVersion.invalidAddressTag);
            }
        }
    }
}

