/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Enumeration;
import sun.security.util.Debug;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.PKIXExtensions;

public class CRLNumberExtension
extends Extension
implements CertAttrSet<String> {
    public static final String NAME = "CRLNumber";
    public static final String NUMBER = "value";
    private static final String LABEL = "CRL Number";
    private BigInteger crlNumber = null;
    private String extensionName;
    private String extensionLabel;

    private void encodeThis() throws IOException {
        if (this.crlNumber == null) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(this.crlNumber);
        this.extensionValue = derOutputStream.toByteArray();
    }

    public CRLNumberExtension(int n) throws IOException {
        this(PKIXExtensions.CRLNumber_Id, false, BigInteger.valueOf(n), NAME, LABEL);
    }

    public CRLNumberExtension(BigInteger bigInteger) throws IOException {
        this(PKIXExtensions.CRLNumber_Id, false, bigInteger, NAME, LABEL);
    }

    protected CRLNumberExtension(ObjectIdentifier objectIdentifier, boolean bl, BigInteger bigInteger, String string, String string2) throws IOException {
        this.extensionId = objectIdentifier;
        this.critical = bl;
        this.crlNumber = bigInteger;
        this.extensionName = string;
        this.extensionLabel = string2;
        this.encodeThis();
    }

    public CRLNumberExtension(Boolean bl, Object object) throws IOException {
        this(PKIXExtensions.CRLNumber_Id, bl, object, NAME, LABEL);
    }

    protected CRLNumberExtension(ObjectIdentifier objectIdentifier, Boolean bl, Object object, String string, String string2) throws IOException {
        this.extensionId = objectIdentifier;
        this.critical = bl;
        this.extensionValue = (byte[])object;
        DerValue derValue = new DerValue(this.extensionValue);
        this.crlNumber = derValue.getBigInteger();
        this.extensionName = string;
        this.extensionLabel = string2;
    }

    @Override
    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(NUMBER)) {
            if (!(object instanceof BigInteger)) {
                throw new IOException("Attribute must be of type BigInteger.");
            }
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:" + this.extensionName + ".");
        }
        this.crlNumber = (BigInteger)object;
        this.encodeThis();
    }

    @Override
    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(NUMBER)) {
            if (this.crlNumber == null) {
                return null;
            }
            return this.crlNumber;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:" + this.extensionName + ".");
    }

    @Override
    public void delete(String string) throws IOException {
        if (!string.equalsIgnoreCase(NUMBER)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:" + this.extensionName + ".");
        }
        this.crlNumber = null;
        this.encodeThis();
    }

    @Override
    public String toString() {
        String string = super.toString() + this.extensionLabel + ": " + (this.crlNumber == null ? "" : Debug.toHexString(this.crlNumber)) + "\n";
        return string;
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.encode(outputStream, PKIXExtensions.CRLNumber_Id, true);
    }

    protected void encode(OutputStream outputStream, ObjectIdentifier objectIdentifier, boolean bl) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = objectIdentifier;
            this.critical = bl;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    @Override
    public Enumeration<String> getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(NUMBER);
        return attributeNameEnumeration.elements();
    }

    @Override
    public String getName() {
        return this.extensionName;
    }
}

