/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.util;

import it.sogei.rcp.util.RCPException;
import java.io.File;
import java.net.URI;

public class Folder
extends File {
    private static final long serialVersionUID = 7280578980386135080L;

    public Folder(String pathname) throws RCPException {
        super(pathname);
        if (!this.validateFolder()) {
            throw new RCPException("l'oggetto passato nel costruttore non corrisponde ad una directory.");
        }
    }

    public Folder(File file) throws RCPException {
        super(file, "");
        if (!this.validateFolder()) {
            throw new RCPException("l'oggetto passato nel costruttore non corrisponde ad una directory.");
        }
    }

    public Folder(URI uri) throws RCPException {
        super(uri);
        if (!this.validateFolder()) {
            throw new RCPException("l'oggetto passato nel costruttore non corrisponde ad una directory.");
        }
    }

    public Folder(String parent, String child) throws RCPException {
        super(parent, child);
        if (!this.validateFolder()) {
            throw new RCPException("l'oggetto passato nel costruttore non corrisponde ad una directory.");
        }
    }

    public Folder(File parent, String child) throws RCPException {
        super(parent, child);
        if (!this.validateFolder()) {
            throw new RCPException("l'oggetto passato nel costruttore non corrisponde ad una directory.");
        }
    }

    public boolean hasChildren() {
        return this.getChildren() != null;
    }

    public Folder[] getChildren() {
        return (Folder[])this.listFiles();
    }

    public String[] getChildrenNames() {
        return super.list();
    }

    public Folder getParentFolder() {
        return (Folder)super.getParentFile();
    }

    private boolean validateFolder() {
        return super.isDirectory();
    }

    public File[] listFiles() {
        File[] files = super.listFiles();
        File[] folders = new Folder[files.length];
        int i = 0;
        while (i < files.length) {
            try {
                folders[i] = new Folder(files[i]);
            }
            catch (RCPException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return folders;
    }
}

