/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.CreateCert;
import demo.Demo;
import iaik.security.ecc.ecdsa.ECDSAKeyPairGeneratorImpl;
import iaik.security.ecc.parameter.ECCParameterFactory;
import iaik.security.ecc.spec.ECCParameterSpec;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import javax.crypto.KeyAgreement;

public class ECDHDemo
implements Demo {
    private String keyAgreement_ = "ECDH";

    protected KeyPair generateKeyPair(ECCParameterSpec eCCParameterSpec) throws Exception {
        ECDSAKeyPairGeneratorImpl eCDSAKeyPairGeneratorImpl = (ECDSAKeyPairGeneratorImpl)KeyPairGenerator.getInstance("ECDSA");
        eCDSAKeyPairGeneratorImpl.initialize(eCCParameterSpec);
        return eCDSAKeyPairGeneratorImpl.generateKeyPair();
    }

    public boolean runDemo() {
        try {
            this.run();
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public void run() throws Exception {
        ECCParameterFactory eCCParameterFactory = ECCParameterFactory.getInstance();
        String string = "b-163";
        ECCParameterSpec eCCParameterSpec = eCCParameterFactory.getParameterByName(string);
        System.out.println("Generating key pair 1");
        KeyPair keyPair = this.generateKeyPair(eCCParameterSpec);
        System.out.println("Generating key pair 2");
        KeyPair keyPair2 = this.generateKeyPair(eCCParameterSpec);
        KeyAgreement keyAgreement = KeyAgreement.getInstance(this.keyAgreement_);
        keyAgreement.init(keyPair.getPrivate());
        keyAgreement.doPhase(keyPair2.getPublic(), true);
        byte[] byArray = keyAgreement.generateSecret();
        KeyAgreement keyAgreement2 = KeyAgreement.getInstance(this.keyAgreement_);
        keyAgreement2.init(keyPair2.getPrivate());
        keyAgreement2.doPhase(keyPair.getPublic(), true);
        byte[] byArray2 = keyAgreement2.generateSecret();
        if (byArray2.length != byArray.length) {
            System.out.println(" ERROR ");
            System.out.println("Shared Secret 1: " + byArray2.length);
            System.out.println("Shared Secret 2: " + byArray2.length);
            throw new RuntimeException("Key agreement failed");
        }
        System.out.print("Checking ");
        int n = 0;
        while (n < byArray.length) {
            System.out.print(" " + n);
            if (byArray[n] != byArray2[n]) {
                System.out.println(" ERROR ");
                throw new RuntimeException("Key agreement failed");
            }
            ++n;
        }
        System.out.println();
        System.out.println("Success !!");
        System.out.println();
    }

    public static void main(String[] stringArray) {
        CreateCert.init();
        ECDHDemo eCDHDemo = new ECDHDemo();
        if (eCDHDemo.runDemo()) {
            System.out.println("FINISHED");
        } else {
            System.out.println("FAILED");
        }
    }
}

