/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.dsig;

import iaik.xml.crypto.XSecProvider;
import iaik.xml.crypto.dsig.TransformImpl;
import iaik.xml.crypto.utils.URI;
import iaik.xml.crypto.utils.URIException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import org.w3c.dom.Node;

public class CanonicalizationMethodImpl
extends TransformImpl
implements CanonicalizationMethod {
    public static final String C14n11_INCLUSIVE_WITH_COMMENTS = "http://www.w3.org/2006/12/xml-c14n11#WithComments";
    public static final String C14n11_INCLUSIVE = "http://www.w3.org/2006/12/xml-c14n11";

    public String getLocalName() {
        return "CanonicalizationMethod";
    }

    public CanonicalizationMethodImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
        try {
            String string = XSecProvider.getDelegationProvider("TransformService." + this.algorithm_.toString());
            this.service_ = string != null ? TransformService.getInstance(this.algorithm_.toString(), "DOM", string) : TransformService.getInstance(this.algorithm_.toString(), "DOM");
            this.service_.init(this, dOMCryptoContext);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new MarshalException(noSuchProviderException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MarshalException(noSuchAlgorithmException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new MarshalException(invalidAlgorithmParameterException);
        }
    }

    public CanonicalizationMethodImpl(String string, TransformParameterSpec transformParameterSpec) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        if (string == null) {
            throw new NullPointerException("Argument 'algorithm' must not be null.");
        }
        try {
            this.algorithm_ = new URI(string);
        }
        catch (URIException uRIException) {
            throw new NoSuchAlgorithmException("Algorithm URI '" + string + "' is not RFC 2396 compliant.");
        }
        String string2 = XSecProvider.getDelegationProvider("TransformService." + this.algorithm_.toString());
        if (string2 != null) {
            try {
                this.service_ = TransformService.getInstance(this.algorithm_.toString(), "DOM", string2);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new NoSuchAlgorithmException("Delegation to non existing provider: " + noSuchProviderException.getMessage());
            }
        } else {
            this.service_ = TransformService.getInstance(this.algorithm_.toString(), "DOM");
        }
        this.service_.init(transformParameterSpec);
    }

    public CanonicalizationMethodImpl(String string, DOMStructure dOMStructure) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        super(string, dOMStructure);
        if (!(this.service_ instanceof CanonicalizationMethod)) {
            throw new NoSuchAlgorithmException("Cannot find algorithm '" + this.algorithm_.toString() + "' for mechanism type 'DOM'.");
        }
    }
}

