/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.OS;

public class ImageList {
    long[] pixbufs;
    int width = -1;
    int height = -1;
    Image[] images = new Image[4];

    public ImageList() {
        this.pixbufs = new long[4];
    }

    public static long convertSurface(Image image) {
        long newSurface = image.surface;
        int type = Cairo.cairo_surface_get_type(newSurface);
        if (type != 0) {
            long cairo;
            Rectangle bounds = image.getBounds();
            int format = Cairo.cairo_surface_get_content(newSurface) == 4096 ? 1 : 0;
            if ((newSurface = Cairo.cairo_image_surface_create(format, bounds.width, bounds.height)) == 0L) {
                SWT.error(2);
            }
            if ((cairo = Cairo.cairo_create(newSurface)) == 0L) {
                SWT.error(2);
            }
            Cairo.cairo_set_operator(cairo, 1);
            Cairo.cairo_set_source_surface(cairo, image.surface, 0.0, 0.0);
            Cairo.cairo_paint(cairo);
            Cairo.cairo_destroy(cairo);
        } else {
            Cairo.cairo_surface_reference(newSurface);
        }
        return newSurface;
    }

    public static long createPixbuf(Image image) {
        long pixbuf;
        if (OS.USE_CAIRO) {
            int ob;
            int og;
            int or;
            int oa;
            int height;
            int width;
            long surface = ImageList.convertSurface(image);
            int format = Cairo.cairo_image_surface_get_format(surface);
            boolean hasAlpha = format == 0;
            pixbuf = OS.gdk_pixbuf_new(0, hasAlpha, 8, width = Cairo.cairo_image_surface_get_width(surface), height = Cairo.cairo_image_surface_get_height(surface));
            if (pixbuf == 0L) {
                SWT.error(2);
            }
            int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
            long pixels = OS.gdk_pixbuf_get_pixels(pixbuf);
            if (OS.BIG_ENDIAN) {
                oa = 0;
                or = 1;
                og = 2;
                ob = 3;
            } else {
                oa = 3;
                or = 2;
                og = 1;
                ob = 0;
            }
            byte[] line = new byte[stride];
            long surfaceData = Cairo.cairo_image_surface_get_data(surface);
            if (hasAlpha) {
                int y = 0;
                while (y < height) {
                    C.memmove(line, surfaceData + (long)(y * stride), (long)stride);
                    int x = 0;
                    int offset = 0;
                    while (x < width) {
                        int a = line[offset + oa] & 0xFF;
                        int r = line[offset + or] & 0xFF;
                        int g = line[offset + og] & 0xFF;
                        int b = line[offset + ob] & 0xFF;
                        line[offset + 3] = (byte)a;
                        if (a != 0) {
                            line[offset + 0] = (byte)((r * 255 + a / 2) / a);
                            line[offset + 1] = (byte)((g * 255 + a / 2) / a);
                            line[offset + 2] = (byte)((b * 255 + a / 2) / a);
                        }
                        ++x;
                        offset += 4;
                    }
                    C.memmove(pixels + (long)(y * stride), line, (long)stride);
                    ++y;
                }
            } else {
                int cairoStride = Cairo.cairo_image_surface_get_stride(surface);
                byte[] cairoLine = new byte[cairoStride];
                int y = 0;
                while (y < height) {
                    C.memmove(cairoLine, surfaceData + (long)(y * cairoStride), (long)cairoStride);
                    int x = 0;
                    int offset = 0;
                    int cairoOffset = 0;
                    while (x < width) {
                        byte r = cairoLine[cairoOffset + or];
                        byte g = cairoLine[cairoOffset + og];
                        byte b = cairoLine[cairoOffset + ob];
                        line[offset + 0] = r;
                        line[offset + 1] = g;
                        line[offset + 2] = b;
                        ++x;
                        offset += 3;
                        cairoOffset += 4;
                    }
                    C.memmove(pixels + (long)(y * stride), line, (long)stride);
                    ++y;
                }
            }
            Cairo.cairo_surface_destroy(surface);
        } else {
            boolean hasMask;
            int[] w = new int[1];
            int[] h = new int[1];
            if (OS.GTK_VERSION >= OS.VERSION(2, 24, 0)) {
                OS.gdk_pixmap_get_size(image.pixmap, w, h);
            } else {
                OS.gdk_drawable_get_size(image.pixmap, w, h);
            }
            long colormap = OS.gdk_colormap_get_system();
            boolean bl = hasMask = image.mask != 0L && OS.gdk_drawable_get_depth(image.mask) == 1;
            if (hasMask) {
                pixbuf = OS.gdk_pixbuf_new(0, true, 8, w[0], h[0]);
                if (pixbuf == 0L) {
                    SWT.error(2);
                }
                OS.gdk_pixbuf_get_from_drawable(pixbuf, image.pixmap, colormap, 0, 0, 0, 0, w[0], h[0]);
                long maskPixbuf = OS.gdk_pixbuf_new(0, false, 8, w[0], h[0]);
                if (maskPixbuf == 0L) {
                    SWT.error(2);
                }
                OS.gdk_pixbuf_get_from_drawable(maskPixbuf, image.mask, 0L, 0, 0, 0, 0, w[0], h[0]);
                int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
                long pixels = OS.gdk_pixbuf_get_pixels(pixbuf);
                byte[] line = new byte[stride];
                int maskStride = OS.gdk_pixbuf_get_rowstride(maskPixbuf);
                long maskPixels = OS.gdk_pixbuf_get_pixels(maskPixbuf);
                byte[] maskLine = new byte[maskStride];
                int y = 0;
                while (y < h[0]) {
                    long offset = pixels + (long)(y * stride);
                    C.memmove(line, offset, (long)stride);
                    long maskOffset = maskPixels + (long)(y * maskStride);
                    C.memmove(maskLine, maskOffset, (long)maskStride);
                    int x = 0;
                    while (x < w[0]) {
                        if (maskLine[x * 3] == 0) {
                            line[x * 4 + 3] = 0;
                        }
                        ++x;
                    }
                    C.memmove(offset, line, (long)stride);
                    ++y;
                }
                OS.g_object_unref(maskPixbuf);
            } else {
                ImageData data = image.getImageData();
                boolean hasAlpha = data.getTransparencyType() == 1;
                pixbuf = OS.gdk_pixbuf_new(0, hasAlpha, 8, w[0], h[0]);
                if (pixbuf == 0L) {
                    SWT.error(2);
                }
                OS.gdk_pixbuf_get_from_drawable(pixbuf, image.pixmap, colormap, 0, 0, 0, 0, w[0], h[0]);
                if (hasAlpha) {
                    byte[] alpha = data.alphaData;
                    int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
                    long pixels = OS.gdk_pixbuf_get_pixels(pixbuf);
                    byte[] line = new byte[stride];
                    int y = 0;
                    while (y < h[0]) {
                        long offset = pixels + (long)(y * stride);
                        C.memmove(line, offset, (long)stride);
                        int x = 0;
                        while (x < w[0]) {
                            line[x * 4 + 3] = alpha[y * w[0] + x];
                            ++x;
                        }
                        C.memmove(offset, line, (long)stride);
                        ++y;
                    }
                }
            }
        }
        return pixbuf;
    }

    public int add(Image image) {
        int index = 0;
        while (index < this.images.length) {
            if (this.images[index] != null && this.images[index].isDisposed()) {
                OS.g_object_unref(this.pixbufs[index]);
                this.images[index] = null;
                this.pixbufs[index] = 0L;
            }
            if (this.images[index] == null) break;
            ++index;
        }
        if (index == this.images.length) {
            Image[] newImages = new Image[this.images.length + 4];
            System.arraycopy(this.images, 0, newImages, 0, this.images.length);
            this.images = newImages;
            long[] newPixbufs = new long[this.pixbufs.length + 4];
            System.arraycopy(this.pixbufs, 0, newPixbufs, 0, this.pixbufs.length);
            this.pixbufs = newPixbufs;
        }
        this.set(index, image);
        return index;
    }

    public void dispose() {
        if (this.pixbufs == null) {
            return;
        }
        int index = 0;
        while (index < this.pixbufs.length) {
            if (this.pixbufs[index] != 0L) {
                OS.g_object_unref(this.pixbufs[index]);
            }
            ++index;
        }
        this.images = null;
        this.pixbufs = null;
    }

    public Image get(int index) {
        return this.images[index];
    }

    public long getPixbuf(int index) {
        return this.pixbufs[index];
    }

    public int indexOf(Image image) {
        if (image == null) {
            return -1;
        }
        int index = 0;
        while (index < this.images.length) {
            if (image == this.images[index]) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int indexOf(long pixbuf) {
        if (pixbuf == 0L) {
            return -1;
        }
        int index = 0;
        while (index < this.images.length) {
            if (pixbuf == this.pixbufs[index]) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public boolean isDisposed() {
        return this.images == null;
    }

    public void put(int index, Image image) {
        int count = this.images.length;
        if (index < 0 || index >= count) {
            return;
        }
        if (image != null) {
            this.set(index, image);
        } else {
            this.images[index] = null;
            if (this.pixbufs[index] != 0L) {
                OS.g_object_unref(this.pixbufs[index]);
            }
            this.pixbufs[index] = 0L;
        }
    }

    public void remove(Image image) {
        if (image == null) {
            return;
        }
        int index = 0;
        while (index < this.images.length) {
            if (image == this.images[index]) {
                OS.g_object_unref(this.pixbufs[index]);
                this.images[index] = null;
                this.pixbufs[index] = 0L;
            }
            ++index;
        }
    }

    void set(int index, Image image) {
        long oldPixbuf;
        long pixbuf = ImageList.createPixbuf(image);
        int w = OS.gdk_pixbuf_get_width(pixbuf);
        int h = OS.gdk_pixbuf_get_height(pixbuf);
        if (this.width == -1 || this.height == -1) {
            this.width = w;
            this.height = h;
        }
        if (w != this.width || h != this.height) {
            long scaledPixbuf = OS.gdk_pixbuf_scale_simple(pixbuf, this.width, this.height, 2);
            OS.g_object_unref(pixbuf);
            pixbuf = scaledPixbuf;
        }
        if ((oldPixbuf = this.pixbufs[index]) != 0L) {
            if (this.images[index] == image) {
                OS.gdk_pixbuf_copy_area(pixbuf, 0, 0, this.width, this.height, oldPixbuf, 0, 0);
                OS.g_object_unref(pixbuf);
                pixbuf = oldPixbuf;
            } else {
                OS.g_object_unref(oldPixbuf);
            }
        }
        this.pixbufs[index] = pixbuf;
        this.images[index] = image;
    }

    public int size() {
        int result = 0;
        int index = 0;
        while (index < this.images.length) {
            if (this.images[index] != null) {
                if (this.images[index].isDisposed()) {
                    OS.g_object_unref(this.pixbufs[index]);
                    this.images[index] = null;
                    this.pixbufs[index] = 0L;
                }
                if (this.images[index] != null) {
                    ++result;
                }
            }
            ++index;
        }
        return result;
    }
}

