/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.x509.V3Extension;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.X509Extensions;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509CRLEntry;
import java.util.Date;
import java.util.Enumeration;
import java.util.Set;

public class RevokedCertificate
extends X509CRLEntry
implements Cloneable {
    private X509Extensions c;
    private ChoiceOfTime b;
    private BigInteger a;

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RevokedCertificate: ");
        stringBuffer.append("serial number: " + this.a + "\n");
        stringBuffer.append("revocation date: " + this.b.getDate() + "\n");
        if (this.hasExtensions()) {
            if (bl) {
                stringBuffer.append(this.c);
            } else {
                stringBuffer.append("Extensions: " + this.c.countExtensions() + "\n");
            }
        } else {
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public ASN1Object toASN1Object() throws CRLException {
        SEQUENCE sEQUENCE = null;
        try {
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(new INTEGER(this.a));
            sEQUENCE.addComponent(this.b.toASN1Object());
            if (this.c != null) {
                sEQUENCE.addComponent(this.c.toASN1Object());
            }
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CRLException(x509ExtensionException.getMessage());
        }
        return sEQUENCE;
    }

    public boolean removeExtension(ObjectID objectID) {
        if (this.c == null) {
            return false;
        }
        return this.c.removeExtension(objectID);
    }

    public void removeAllExtensions() {
        if (this.c != null) {
            this.c.removeAllExtensions();
        }
    }

    public Enumeration listExtensions() {
        if (this.c == null) {
            return null;
        }
        return this.c.listExtensions();
    }

    public boolean hasUnsupportedCriticalExtension() {
        if (this.c == null) {
            return false;
        }
        return this.c.hasUnsupportedCriticalExtension();
    }

    public boolean hasExtensions() {
        if (this.c == null) {
            return false;
        }
        return this.c.hasExtensions();
    }

    public BigInteger getSerialNumber() {
        return this.a;
    }

    public Date getRevocationDate() {
        return this.b.getDate();
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.c == null) {
            return null;
        }
        return this.c.getNonCriticalExtensionOIDs();
    }

    public byte[] getExtensionValue(String string) {
        if (this.c == null) {
            return null;
        }
        return this.c.getExtensionValue(string);
    }

    public V3Extension getExtension(ObjectID objectID) throws X509ExtensionInitException {
        if (this.c == null) {
            return null;
        }
        return this.c.getExtension(objectID);
    }

    public byte[] getEncoded() throws CRLException {
        return DerCoder.encode(this.toASN1Object());
    }

    public Set getCriticalExtensionOIDs() {
        if (this.c == null) {
            return null;
        }
        return this.c.getCriticalExtensionOIDs();
    }

    private void a(ASN1Object aSN1Object) throws CodingException {
        if (aSN1Object == null) {
            throw new NullPointerException("Cannot parse revoked certificate from a null object!");
        }
        try {
            BigInteger bigInteger = (BigInteger)aSN1Object.getComponentAt(0).getValue();
            ChoiceOfTime choiceOfTime = new ChoiceOfTime(aSN1Object.getComponentAt(1));
            X509Extensions x509Extensions = aSN1Object.countComponents() > 2 ? new X509Extensions(aSN1Object.getComponentAt(2)) : null;
            this.a = bigInteger;
            this.b = choiceOfTime;
            this.c = x509Extensions;
            return;
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CodingException(x509ExtensionException.getMessage());
        }
    }

    public int countExtensions() {
        if (this.c == null) {
            return 0;
        }
        return this.c.countExtensions();
    }

    public Object clone() {
        RevokedCertificate revokedCertificate = null;
        try {
            revokedCertificate = (RevokedCertificate)super.clone();
            revokedCertificate.a(this.toASN1Object());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
        }
        catch (Exception exception) {}
        return revokedCertificate;
    }

    public void addExtension(V3Extension v3Extension) throws X509ExtensionException {
        if (this.c == null) {
            this.c = new X509Extensions();
        }
        this.c.addExtension(v3Extension);
    }

    public RevokedCertificate(BigInteger bigInteger, Date date) {
        this.a = bigInteger;
        this.b = new ChoiceOfTime(date, true);
    }

    public RevokedCertificate(X509Certificate x509Certificate, Date date) {
        this.a = x509Certificate.getSerialNumber();
        this.b = new ChoiceOfTime(date, true);
    }

    public RevokedCertificate(ASN1Object aSN1Object) throws CRLException {
        try {
            this.a(aSN1Object);
            return;
        }
        catch (CodingException codingException) {
            throw new CRLException(codingException.getMessage());
        }
    }

    RevokedCertificate() {
    }
}

