/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.chunkupload.jobs;

import it.sogei.rcp.chunkupload.internal.ChunkUploadCore;
import it.sogei.rcp.chunkupload.model.FileChunkUploadBean;
import it.sogei.rcp.chunkupload.model.OpzioniChunkUploadBean;
import it.sogei.rcp.jobs.boundary.IJobCommand;
import it.sogei.utilities.log4j.LogUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.Timer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ChunkUploadJobCommand
implements IJobCommand {
    private OpzioniChunkUploadBean opzioni;
    private IProgressMonitor monitor;
    private FileChunkUploadBean fileChunkUploadBean;
    private File fileIn;
    private double ctr = 0.0;
    private double etl = 0.0;
    private Timer timer;
    final long start = new Date().getTime();
    final SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
    final TimeZone tz = TimeZone.getTimeZone("UTC");
    private ChunkUploadCore chunkUploadCore;
    Job job;

    public ChunkUploadJobCommand(OpzioniChunkUploadBean opzioniIn, FileChunkUploadBean fileChunkUploadBeanIn) {
        this.chunkUploadCore = new ChunkUploadCore(opzioniIn, fileChunkUploadBeanIn);
        this.opzioni = opzioniIn;
        this.fileChunkUploadBean = this.chunkUploadCore.getFileChunkUploadBean();
        this.fileIn = new File(this.fileChunkUploadBean.getPath());
        this.fileChunkUploadBean.setNomeNormalizzato(this.chunkUploadCore.getFileChunkUploadBean().getNomeNormalizzato());
        LogUtil.log((String)"ChunkUploadJobCommand - ", (int)1, (String)"Job Command instanziato");
        LogUtil.log((String)"ChunkUploadJobCommand - ", (int)1, (String)("FileIn: " + this.fileIn.getPath()));
        LogUtil.log((String)"ChunkUploadJobCommand - ", (int)1, (String)("FileIn: " + this.fileChunkUploadBean.getNomeNormalizzato()));
    }

    public IStatus execute(IProgressMonitor arg0) {
        this.fileChunkUploadBean.setStato("in upload...");
        this.monitor = arg0;
        this.monitor.beginTask("upload in corso...", (int)this.fileIn.length());
        try {
            this.fileChunkUploadBean.addPropertyChangeListener("offset", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent arg0) {
                    if (ChunkUploadJobCommand.this.fileChunkUploadBean.getOffset() != null) {
                        ChunkUploadJobCommand.this.monitor.setTaskName("in upload: " + ChunkUploadJobCommand.this.fileChunkUploadBean.getOffset() + " Kb inviati");
                        ChunkUploadJobCommand.this.monitor.worked(ChunkUploadJobCommand.this.opzioni.getChunk_size());
                        LogUtil.log((String)"ChunkUploadJobCommand - ", (int)1, (String)("Offset: " + ChunkUploadJobCommand.this.fileChunkUploadBean.getOffset()));
                    }
                }
            });
            this.fileChunkUploadBean.addPropertyChangeListener("offsetIniziale", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent arg0) {
                    if (ChunkUploadJobCommand.this.fileChunkUploadBean.getOffsetIniziale() != null) {
                        LogUtil.log((String)"ChunkUploadJobCommand - ", (int)1, (String)("Offset Iniziale: " + ChunkUploadJobCommand.this.fileChunkUploadBean.getOffsetIniziale()));
                        ChunkUploadJobCommand.this.monitor.worked(Integer.parseInt(ChunkUploadJobCommand.this.fileChunkUploadBean.getOffsetIniziale()));
                    }
                }
            });
            this.fileChunkUploadBean.addPropertyChangeListener("stato", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent arg0) {
                    if (ChunkUploadJobCommand.this.fileChunkUploadBean.getStato().equals("cancellato") || ChunkUploadJobCommand.this.fileChunkUploadBean.getStato().equals("errore")) {
                        LogUtil.log((String)"ChunkUploadJobCommand - ", (int)1, (String)("Job Cancellato o interrotto, stato job: " + ChunkUploadJobCommand.this.fileChunkUploadBean.getStato()));
                        ChunkUploadJobCommand.this.job.cancel();
                    }
                }
            });
            this.job = new Job("chunkUpload"){

                protected IStatus run(IProgressMonitor mon) {
                    ChunkUploadJobCommand.this.chunkUploadCore.upload();
                    return Status.OK_STATUS;
                }
            };
            this.job.setSystem(true);
            this.job.schedule();
            while (this.chunkUploadCore.getFileChunkUploadBean().getStato().equals("in upload...")) {
                if (!this.monitor.isCanceled()) continue;
                LogUtil.log((String)"ChunkUploadJobCommand - ", (int)1, (String)("Upload stoppato - path: " + this.fileChunkUploadBean.getPath()));
                LogUtil.log((String)"ChunkUploadJobCommand - ", (int)1, (String)("Upload stoppato - messaggio in file bean: " + this.fileChunkUploadBean.getMessaggio()));
                LogUtil.log((String)"ChunkUploadJobCommand - ", (int)1, (String)("Upload stoppato - offset: " + this.fileChunkUploadBean.getOffset()));
                this.chunkUploadCore.stopUpload();
                break;
            }
            if (this.monitor.isCanceled()) {
                this.fileChunkUploadBean.setStato("cancellato");
                LogUtil.log((String)"ChunkUploadJobCommand - ", (int)1, (String)("Upload cancellato - path: " + this.fileChunkUploadBean.getPath()));
                LogUtil.log((String)"ChunkUploadJobCommand - ", (int)1, (String)("Upload cancellato - messaggio in file bean: " + this.fileChunkUploadBean.getMessaggio()));
                LogUtil.log((String)"ChunkUploadJobCommand - ", (int)1, (String)("Upload cancellato - offset: " + this.fileChunkUploadBean.getOffset()));
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            if (this.fileChunkUploadBean.getStato().equals("errore")) {
                LogUtil.log((String)"ChunkUploadJobCommand - ", (int)1, (String)("Errore in upload: path: " + this.fileChunkUploadBean.getPath()));
                LogUtil.log((String)"ChunkUploadJobCommand - ", (int)1, (String)("Errore in upload: " + this.fileChunkUploadBean.getMessaggio()));
                LogUtil.log((String)"ChunkUploadJobCommand - ", (int)1, (String)("Errore in upload: offset: " + this.fileChunkUploadBean.getOffset()));
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.fileChunkUploadBean.setStato("upload ok");
            LogUtil.log((String)"ChunkUploadJobCommand - ", (int)1, (String)("upload ok - path: " + this.fileChunkUploadBean.getPath()));
            LogUtil.log((String)"ChunkUploadJobCommand - ", (int)1, (String)("upload ok - messaggio " + this.fileChunkUploadBean.getMessaggio()));
            LogUtil.log((String)"ChunkUploadJobCommand - ", (int)1, (String)("upload ok - offset: " + this.fileChunkUploadBean.getOffset()));
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            this.monitor.done();
        }
    }

    public String getName() {
        return "Upload file: " + this.fileChunkUploadBean.getPath();
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }
}

