/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.security.AlgorithmConstraints;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.util.EnumSet;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLHandshakeException;
import sun.security.ssl.Alert;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.HKDF;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.JsseJce;
import sun.security.ssl.SSLCredentials;
import sun.security.ssl.SSLKeyAgreementGenerator;
import sun.security.ssl.SSLKeyDerivation;
import sun.security.ssl.SSLMasterKeyDerivation;
import sun.security.ssl.SSLPossession;
import sun.security.ssl.SSLPossessionGenerator;
import sun.security.ssl.SSLSecretDerivation;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SupportedGroupsExtension;
import sun.security.ssl.X509Authentication;
import sun.security.util.ECUtil;

final class ECDHKeyExchange {
    static final SSLPossessionGenerator poGenerator = new ECDHEPossessionGenerator();
    static final SSLKeyAgreementGenerator ecdheKAGenerator = new ECDHEKAGenerator();
    static final SSLKeyAgreementGenerator ecdhKAGenerator = new ECDHKAGenerator();

    ECDHKeyExchange() {
    }

    private static final class ECDHEKAKeyDerivation
    implements SSLKeyDerivation {
        private final HandshakeContext context;
        private final PrivateKey localPrivateKey;
        private final PublicKey peerPublicKey;

        ECDHEKAKeyDerivation(HandshakeContext handshakeContext, PrivateKey privateKey, PublicKey publicKey) {
            this.context = handshakeContext;
            this.localPrivateKey = privateKey;
            this.peerPublicKey = publicKey;
        }

        @Override
        public SecretKey deriveKey(String string, AlgorithmParameterSpec algorithmParameterSpec) throws IOException {
            if (!this.context.negotiatedProtocol.useTLS13PlusSpec()) {
                return this.t12DeriveKey(string, algorithmParameterSpec);
            }
            return this.t13DeriveKey(string, algorithmParameterSpec);
        }

        private SecretKey t12DeriveKey(String string, AlgorithmParameterSpec algorithmParameterSpec) throws IOException {
            try {
                KeyAgreement keyAgreement = JsseJce.getKeyAgreement("ECDH");
                keyAgreement.init(this.localPrivateKey);
                keyAgreement.doPhase(this.peerPublicKey, true);
                SecretKey secretKey = keyAgreement.generateSecret("TlsPremasterSecret");
                SSLMasterKeyDerivation sSLMasterKeyDerivation = SSLMasterKeyDerivation.valueOf(this.context.negotiatedProtocol);
                if (sSLMasterKeyDerivation == null) {
                    throw new SSLHandshakeException("No expected master key derivation for protocol: " + this.context.negotiatedProtocol.name);
                }
                SSLKeyDerivation sSLKeyDerivation = sSLMasterKeyDerivation.createKeyDerivation(this.context, secretKey);
                return sSLKeyDerivation.deriveKey("MasterSecret", algorithmParameterSpec);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(generalSecurityException);
            }
        }

        private SecretKey t13DeriveKey(String string, AlgorithmParameterSpec algorithmParameterSpec) throws IOException {
            try {
                Object object;
                KeyAgreement keyAgreement = JsseJce.getKeyAgreement("ECDH");
                keyAgreement.init(this.localPrivateKey);
                keyAgreement.doPhase(this.peerPublicKey, true);
                SecretKey secretKey = keyAgreement.generateSecret("TlsPremasterSecret");
                CipherSuite.HashAlg hashAlg = this.context.negotiatedCipherSuite.hashAlg;
                SSLKeyDerivation sSLKeyDerivation = this.context.handshakeKeyDerivation;
                HKDF hKDF = new HKDF(hashAlg.name);
                if (sSLKeyDerivation == null) {
                    object = new byte[hashAlg.hashLength];
                    SecretKeySpec secretKeySpec = new SecretKeySpec((byte[])object, "TlsPreSharedSecret");
                    SecretKey secretKey2 = hKDF.extract((byte[])object, (SecretKey)secretKeySpec, "TlsEarlySecret");
                    sSLKeyDerivation = new SSLSecretDerivation(this.context, secretKey2);
                }
                object = sSLKeyDerivation.deriveKey("TlsSaltSecret", null);
                return hKDF.extract((SecretKey)object, secretKey, string);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(generalSecurityException);
            }
        }
    }

    private static final class ECDHEKAGenerator
    implements SSLKeyAgreementGenerator {
        private ECDHEKAGenerator() {
        }

        @Override
        public SSLKeyDerivation createKeyDerivation(HandshakeContext handshakeContext) throws IOException {
            ECDHEPossession eCDHEPossession = null;
            ECDHECredentials eCDHECredentials = null;
            for (SSLPossession sSLPossession : handshakeContext.handshakePossessions) {
                if (!(sSLPossession instanceof ECDHEPossession)) continue;
                SupportedGroupsExtension.NamedGroup namedGroup = ((ECDHEPossession)sSLPossession).namedGroup;
                for (SSLCredentials sSLCredentials : handshakeContext.handshakeCredentials) {
                    if (!(sSLCredentials instanceof ECDHECredentials) || !namedGroup.equals((Object)((ECDHECredentials)sSLCredentials).namedGroup)) continue;
                    eCDHECredentials = (ECDHECredentials)sSLCredentials;
                    break;
                }
                if (eCDHECredentials == null) continue;
                eCDHEPossession = (ECDHEPossession)sSLPossession;
                break;
            }
            if (eCDHEPossession == null || eCDHECredentials == null) {
                handshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No sufficient ECDHE key agreement parameters negotiated");
            }
            return new ECDHEKAKeyDerivation(handshakeContext, eCDHEPossession.privateKey, eCDHECredentials.popPublicKey);
        }
    }

    private static final class ECDHKAGenerator
    implements SSLKeyAgreementGenerator {
        private ECDHKAGenerator() {
        }

        @Override
        public SSLKeyDerivation createKeyDerivation(HandshakeContext handshakeContext) throws IOException {
            if (handshakeContext instanceof ServerHandshakeContext) {
                return this.createServerKeyDerivation((ServerHandshakeContext)handshakeContext);
            }
            return this.createClientKeyDerivation((ClientHandshakeContext)handshakeContext);
        }

        private SSLKeyDerivation createServerKeyDerivation(ServerHandshakeContext serverHandshakeContext) throws IOException {
            X509Authentication.X509Possession x509Possession = null;
            ECDHECredentials eCDHECredentials = null;
            for (SSLPossession sSLPossession : serverHandshakeContext.handshakePossessions) {
                ECParameterSpec eCParameterSpec;
                if (!(sSLPossession instanceof X509Authentication.X509Possession) || (eCParameterSpec = ((X509Authentication.X509Possession)sSLPossession).getECParameterSpec()) == null) continue;
                SupportedGroupsExtension.NamedGroup namedGroup = SupportedGroupsExtension.NamedGroup.valueOf(eCParameterSpec);
                if (namedGroup == null) {
                    serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unsupported EC server cert for ECDH key exchange");
                }
                for (SSLCredentials sSLCredentials : serverHandshakeContext.handshakeCredentials) {
                    if (!(sSLCredentials instanceof ECDHECredentials) || !namedGroup.equals((Object)((ECDHECredentials)sSLCredentials).namedGroup)) continue;
                    eCDHECredentials = (ECDHECredentials)sSLCredentials;
                    break;
                }
                if (eCDHECredentials == null) continue;
                x509Possession = (X509Authentication.X509Possession)sSLPossession;
                break;
            }
            if (x509Possession == null || eCDHECredentials == null) {
                serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No sufficient ECDHE key agreement parameters negotiated");
            }
            return new ECDHEKAKeyDerivation(serverHandshakeContext, x509Possession.popPrivateKey, eCDHECredentials.popPublicKey);
        }

        private SSLKeyDerivation createClientKeyDerivation(ClientHandshakeContext clientHandshakeContext) throws IOException {
            ECDHEPossession eCDHEPossession = null;
            X509Authentication.X509Credentials x509Credentials = null;
            for (SSLPossession sSLPossession : clientHandshakeContext.handshakePossessions) {
                if (!(sSLPossession instanceof ECDHEPossession)) continue;
                SupportedGroupsExtension.NamedGroup namedGroup = ((ECDHEPossession)sSLPossession).namedGroup;
                for (SSLCredentials sSLCredentials : clientHandshakeContext.handshakeCredentials) {
                    PublicKey publicKey;
                    if (!(sSLCredentials instanceof X509Authentication.X509Credentials) || !(publicKey = ((X509Authentication.X509Credentials)sSLCredentials).popPublicKey).getAlgorithm().equals("EC")) continue;
                    ECParameterSpec eCParameterSpec = ((ECPublicKey)publicKey).getParams();
                    SupportedGroupsExtension.NamedGroup namedGroup2 = SupportedGroupsExtension.NamedGroup.valueOf(eCParameterSpec);
                    if (namedGroup2 == null) {
                        clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unsupported EC server cert for ECDH key exchange");
                    }
                    if (!namedGroup.equals((Object)namedGroup2)) continue;
                    x509Credentials = (X509Authentication.X509Credentials)sSLCredentials;
                    break;
                }
                if (x509Credentials == null) continue;
                eCDHEPossession = (ECDHEPossession)sSLPossession;
                break;
            }
            if (eCDHEPossession == null || x509Credentials == null) {
                clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No sufficient ECDH key agreement parameters negotiated");
            }
            return new ECDHEKAKeyDerivation(clientHandshakeContext, eCDHEPossession.privateKey, x509Credentials.popPublicKey);
        }
    }

    private static final class ECDHEPossessionGenerator
    implements SSLPossessionGenerator {
        private ECDHEPossessionGenerator() {
        }

        @Override
        public SSLPossession createPossession(HandshakeContext handshakeContext) {
            SupportedGroupsExtension.NamedGroup namedGroup = null;
            namedGroup = handshakeContext.clientRequestedNamedGroups != null && !handshakeContext.clientRequestedNamedGroups.isEmpty() ? SupportedGroupsExtension.SupportedGroups.getPreferredGroup(handshakeContext.negotiatedProtocol, handshakeContext.algorithmConstraints, SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_ECDHE, handshakeContext.clientRequestedNamedGroups) : SupportedGroupsExtension.SupportedGroups.getPreferredGroup(handshakeContext.negotiatedProtocol, handshakeContext.algorithmConstraints, SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_ECDHE);
            if (namedGroup != null) {
                return new ECDHEPossession(namedGroup, handshakeContext.sslContext.getSecureRandom());
            }
            return null;
        }
    }

    static final class ECDHEPossession
    implements SSLPossession {
        final PrivateKey privateKey;
        final ECPublicKey publicKey;
        final SupportedGroupsExtension.NamedGroup namedGroup;

        ECDHEPossession(SupportedGroupsExtension.NamedGroup namedGroup, SecureRandom secureRandom) {
            try {
                KeyPairGenerator keyPairGenerator = JsseJce.getKeyPairGenerator("EC");
                ECGenParameterSpec eCGenParameterSpec = (ECGenParameterSpec)namedGroup.getParameterSpec();
                keyPairGenerator.initialize(eCGenParameterSpec, secureRandom);
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                this.privateKey = keyPair.getPrivate();
                this.publicKey = (ECPublicKey)keyPair.getPublic();
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new RuntimeException("Could not generate ECDH keypair", generalSecurityException);
            }
            this.namedGroup = namedGroup;
        }

        ECDHEPossession(ECDHECredentials eCDHECredentials, SecureRandom secureRandom) {
            ECParameterSpec eCParameterSpec = eCDHECredentials.popPublicKey.getParams();
            try {
                KeyPairGenerator keyPairGenerator = JsseJce.getKeyPairGenerator("EC");
                keyPairGenerator.initialize(eCParameterSpec, secureRandom);
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                this.privateKey = keyPair.getPrivate();
                this.publicKey = (ECPublicKey)keyPair.getPublic();
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new RuntimeException("Could not generate ECDH keypair", generalSecurityException);
            }
            this.namedGroup = eCDHECredentials.namedGroup;
        }

        @Override
        public byte[] encode() {
            return ECUtil.encodePoint(this.publicKey.getW(), this.publicKey.getParams().getCurve());
        }

        SecretKey getAgreedSecret(PublicKey publicKey) throws SSLHandshakeException {
            try {
                KeyAgreement keyAgreement = JsseJce.getKeyAgreement("ECDH");
                keyAgreement.init(this.privateKey);
                keyAgreement.doPhase(publicKey, true);
                return keyAgreement.generateSecret("TlsPremasterSecret");
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(generalSecurityException);
            }
        }

        SecretKey getAgreedSecret(byte[] byArray) throws SSLHandshakeException {
            try {
                ECParameterSpec eCParameterSpec = this.publicKey.getParams();
                ECPoint eCPoint = JsseJce.decodePoint(byArray, eCParameterSpec.getCurve());
                KeyFactory keyFactory = JsseJce.getKeyFactory("EC");
                ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, eCParameterSpec);
                PublicKey publicKey = keyFactory.generatePublic(eCPublicKeySpec);
                return this.getAgreedSecret(publicKey);
            }
            catch (IOException | GeneralSecurityException exception) {
                throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(exception);
            }
        }

        void checkConstraints(AlgorithmConstraints algorithmConstraints, byte[] byArray) throws SSLHandshakeException {
            try {
                ECParameterSpec eCParameterSpec = this.publicKey.getParams();
                ECPoint eCPoint = JsseJce.decodePoint(byArray, eCParameterSpec.getCurve());
                ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, eCParameterSpec);
                KeyFactory keyFactory = JsseJce.getKeyFactory("EC");
                ECPublicKey eCPublicKey = (ECPublicKey)keyFactory.generatePublic(eCPublicKeySpec);
                if (!algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), eCPublicKey)) {
                    throw new SSLHandshakeException("ECPublicKey does not comply to algorithm constraints");
                }
            }
            catch (IOException | GeneralSecurityException exception) {
                throw (SSLHandshakeException)new SSLHandshakeException("Could not generate ECPublicKey").initCause(exception);
            }
        }
    }

    static final class ECDHECredentials
    implements SSLCredentials {
        final ECPublicKey popPublicKey;
        final SupportedGroupsExtension.NamedGroup namedGroup;

        ECDHECredentials(ECPublicKey eCPublicKey, SupportedGroupsExtension.NamedGroup namedGroup) {
            this.popPublicKey = eCPublicKey;
            this.namedGroup = namedGroup;
        }

        static ECDHECredentials valueOf(SupportedGroupsExtension.NamedGroup namedGroup, byte[] byArray) throws IOException, GeneralSecurityException {
            if (namedGroup.type != SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_ECDHE) {
                throw new RuntimeException("Credentials decoding:  Not ECDHE named group");
            }
            if (byArray == null || byArray.length == 0) {
                return null;
            }
            ECParameterSpec eCParameterSpec = JsseJce.getECParameterSpec(namedGroup.oid);
            if (eCParameterSpec == null) {
                return null;
            }
            ECPoint eCPoint = JsseJce.decodePoint(byArray, eCParameterSpec.getCurve());
            KeyFactory keyFactory = JsseJce.getKeyFactory("EC");
            ECPublicKey eCPublicKey = (ECPublicKey)keyFactory.generatePublic(new ECPublicKeySpec(eCPoint, eCParameterSpec));
            return new ECDHECredentials(eCPublicKey, namedGroup);
        }
    }
}

