/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.security.login.modules;

import it.sogei.rcp.security.login.beans.UtentiBean;
import it.sogei.rcp.security.login.db.DesktopDB;
import it.sogei.rcp.security.login.utils.UserPrincipal;
import java.io.IOException;
import java.security.Principal;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class RCPLoginModule
implements LoginModule {
    private static final String USERNAME_KEY = "javax.security.auth.login.name";
    private static final String PASSWORD_KEY = "javax.security.auth.login.password";
    private CallbackHandler callbackHandler;
    private Subject subject;
    private Map sharedState;
    private Map options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;
    private char[] password;
    private DesktopDB desktopDB;
    private UserPrincipal userPrincipal;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.desktopDB = new DesktopDB();
    }

    @Override
    public boolean login() throws LoginException {
        if (this.sharedState != null && this.sharedState.containsKey(USERNAME_KEY) && this.sharedState.containsKey(PASSWORD_KEY)) {
            try {
                this.attemptAuthentication(true);
            }
            catch (LoginException loginException) {
                this.cleanState();
            }
        }
        try {
            this.attemptAuthentication(false);
            this.succeeded = true;
            return true;
        }
        catch (LoginException e) {
            this.cleanState();
            throw e;
        }
        finally {
            try {
                this.desktopDB.shutdown();
            }
            catch (SQLException e) {
                throw new LoginException(e.getMessage());
            }
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        this.checkSubject();
        Set<Principal> principals = this.subject.getPrincipals();
        if (!principals.contains(this.userPrincipal)) {
            principals.add(this.userPrincipal);
        }
        this.subject.getPublicCredentials().add(this.getUserRoles(this.username));
        this.cleanState();
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.cleanState();
            this.userPrincipal = null;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.checkSubject();
        Set<Principal> principals = this.subject.getPrincipals();
        principals.remove(this.userPrincipal);
        this.cleanState();
        this.succeeded = false;
        this.commitSucceeded = false;
        this.userPrincipal = null;
        return true;
    }

    private void attemptAuthentication(boolean fromSharedState) throws LoginException {
        this.getUsernamePassword(fromSharedState);
        this.performAuthentication();
        this.storeUserIdentity();
        this.userPrincipal = new UserPrincipal(this.username, this.getUserRoles(this.username));
    }

    private void storeUserIdentity() {
        if (!this.sharedState.containsKey(USERNAME_KEY) && !this.sharedState.containsKey(PASSWORD_KEY)) {
            this.sharedState.put(USERNAME_KEY, this.username);
            this.sharedState.put(PASSWORD_KEY, this.password);
        }
    }

    private void performAuthentication() throws FailedLoginException {
        UtentiBean utente;
        try {
            utente = this.desktopDB.getUtente(this.username);
        }
        catch (SQLException e) {
            throw new FailedLoginException(e.getMessage());
        }
        if (utente == null) {
            throw new FailedLoginException("User " + this.username + " not found in registry");
        }
        if (!utente.getPassword().equals(new String(this.password))) {
            throw new FailedLoginException("Authentication failed for user " + this.username);
        }
    }

    private void checkPassword() throws FailedLoginException {
        if (this.password == null || this.password.length == 0) {
            throw new FailedLoginException("No password was supplied");
        }
    }

    private void getUsernamePassword(boolean fromSharedState) throws LoginException {
        if (fromSharedState) {
            this.username = (String)this.sharedState.get(USERNAME_KEY);
            this.password = (char[])this.sharedState.get(PASSWORD_KEY);
            return;
        }
        if (this.callbackHandler == null) {
            throw new LoginException("No CallbackHandler available");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("Username:"), new PasswordCallback("Password:", false)};
        try {
            this.callbackHandler.handle(callbacks);
            this.username = ((NameCallback)callbacks[0]).getName();
            this.password = RCPLoginModule.extractPassword((PasswordCallback)callbacks[1]);
        }
        catch (IOException e) {
            throw new LoginException(e.toString());
        }
        catch (UnsupportedCallbackException e) {
            throw new LoginException("Error: " + e.getCallback().toString() + " not available");
        }
    }

    private static char[] extractPassword(PasswordCallback callback) {
        char[] tmpPassword = callback.getPassword();
        if (tmpPassword != null && tmpPassword.length > 0) {
            char[] password = new char[tmpPassword.length];
            System.arraycopy(tmpPassword, 0, password, 0, tmpPassword.length);
            callback.clearPassword();
            return password;
        }
        return "".toCharArray();
    }

    private void cleanState() {
        this.username = null;
        if (this.password != null) {
            Arrays.fill(this.password, ' ');
            this.password = null;
        }
        this.sharedState.remove(USERNAME_KEY);
        this.sharedState.remove(PASSWORD_KEY);
    }

    private void checkSubject() throws LoginException {
        if (this.subject.isReadOnly()) {
            this.cleanState();
            throw new LoginException("Subject is read-only");
        }
    }

    private List<String> getUserRoles(String username) throws LoginException {
        try {
            UtentiBean utente = this.desktopDB.getUtente(username);
            if (utente != null) {
                return utente.getRuoliAsList();
            }
            return null;
        }
        catch (SQLException e) {
            throw new LoginException(e.getMessage());
        }
    }
}

