/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.DebugCMS;
import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSRuntimeException;
import iaik.cms.CertificateSet;
import iaik.cms.DataOutputStream;
import iaik.cms.RevocationInfoChoices;
import iaik.cms.SecurityProvider;
import iaik.cms.SignerInfo;
import iaik.cms.Utils;
import iaik.cms.g;
import iaik.cms.v;
import iaik.cms.x;
import iaik.utils.Util;
import iaik.x509.X509CRL;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Vector;

public class SignedDataOutputStream
extends OutputStream
implements g {
    private boolean d = true;
    private boolean h;
    private SecurityProvider c;
    private int f = 1;
    private OutputStream k;
    private OutputStream e;
    private Vector b;
    private RevocationInfoChoices i;
    private CertificateSet l;
    private ObjectID j;
    private x g = new x(this);
    private int a = 1;
    public static final int EXPLICIT = 2;
    public static final int IMPLICIT = 1;
    private static boolean m = DebugCMS.getDebugMode() && m;

    static SecurityProvider a(SignedDataOutputStream signedDataOutputStream) {
        return signedDataOutputStream.c;
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.b();
        this.k.write(byArray, n2, n3);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(int n2) throws IOException {
        this.write(new byte[]{(byte)(n2 & 0xFF)}, 0, 1);
    }

    public String toString(boolean bl) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.a + "\n");
        AlgorithmID[] algorithmIDArray = this.g.a();
        if (algorithmIDArray.length > 0) {
            stringBuffer.append("DigestAlgorithms: ");
            n2 = 0;
            while (n2 < algorithmIDArray.length) {
                stringBuffer.append(String.valueOf(algorithmIDArray[n2].getName()) + ",");
                ++n2;
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            stringBuffer.append("\n");
        }
        stringBuffer.append("EncapsulatedContentInfo: {\n");
        Utils.printIndented("ContentType: " + this.j.getName() + (this.f == 1 ? ", content included\n" : ", no content\n"), true, stringBuffer);
        if (this.l != null && !this.l.isEmpty()) {
            stringBuffer.append(this.l);
        }
        if (this.i != null && !this.i.isEmpty()) {
            stringBuffer.append(this.i);
        }
        stringBuffer.append("SignerInfos: " + this.b.size() + "\n");
        if (bl) {
            n2 = 1;
            Enumeration enumeration = this.b.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append("SignerInfo " + n2 + ": {\n");
                Utils.printIndented(((SignerInfo)enumeration.nextElement()).toString(true), true, stringBuffer);
                stringBuffer.append("\n}\n");
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public void setSignerInfos(SignerInfo[] signerInfoArray) throws NoSuchAlgorithmException {
        this.b.removeAllElements();
        if (signerInfoArray != null) {
            int n2 = 0;
            while (n2 < signerInfoArray.length) {
                SignerInfo signerInfo = signerInfoArray[n2];
                if (signerInfo != null) {
                    this.addSignerInfo(signerInfoArray[n2]);
                }
                ++n2;
            }
        }
        this.a();
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.c = securityProvider;
        if (this.b != null) {
            Object[] objectArray = Util.toArray((Vector)this.b);
            int n2 = 0;
            while (n2 < objectArray.length) {
                SignerInfo signerInfo = (SignerInfo)objectArray[n2];
                if (signerInfo.getSecurityProvider() == null) {
                    signerInfo.setSecurityProvider(this.c);
                }
                ++n2;
            }
        }
    }

    public void setRevocationInfoChoices(RevocationInfoChoices revocationInfoChoices) {
        if (revocationInfoChoices == null) {
            this.i.removeAllRevocationInfos();
        } else {
            this.i = revocationInfoChoices;
        }
        this.a();
    }

    public void setPassThroughClose(boolean bl) {
        this.d = bl;
    }

    public void setMessageDigest(AlgorithmID algorithmID, byte[] byArray) throws NoSuchAlgorithmException {
        this.g.b(algorithmID, byArray);
    }

    public void setCertificates(Certificate[] certificateArray) {
        if (certificateArray == null || certificateArray.length == 0) {
            this.l.removeAllCertificates();
        } else {
            this.l.setCertificates(certificateArray);
        }
        this.a();
    }

    public void setCertificateSet(CertificateSet certificateSet) {
        if (certificateSet == null) {
            this.l.removeAllCertificates();
        } else {
            this.l = certificateSet;
        }
        this.a();
    }

    public void setCRLs(X509CRL[] x509CRLArray) {
        if (x509CRLArray == null || x509CRLArray.length == 0) {
            this.i.removeAllRevocationInfos();
        } else {
            this.i.setRevocationInfos((CRL[])x509CRLArray);
        }
        this.a();
    }

    public boolean isPassThroughClose() {
        return this.d;
    }

    public SecurityProvider getSecurityProvider() {
        return this.c;
    }

    public byte[] getMessageDigest(AlgorithmID algorithmID) throws CMSRuntimeException, NoSuchAlgorithmException {
        return this.g.c(algorithmID);
    }

    public void flush() throws IOException {
        this.b();
        this.k.flush();
    }

    private void b() throws IOException {
        if (!this.h) {
            try {
                this.e.write(new byte[]{48, -128});
                this.e.write(DerCoder.encode((ASN1Object)new INTEGER(this.a)));
                this.e.write(DerCoder.encode((ASN1Object)ASN.createSetOf((ASN1Type[])this.g.a())));
                this.e.write(new byte[]{48, -128});
                this.e.write(DerCoder.encode((ASN1Object)this.j));
                if (this.f == 1) {
                    this.e.write(new byte[]{-96, -128});
                }
                this.h = true;
                return;
            }
            catch (CodingException codingException) {
                throw new IOException(codingException.toString());
            }
        }
    }

    public void close() throws IOException {
        this.b();
        this.k.close();
        if (this.f == 1) {
            this.e.write(new byte[2]);
        }
        this.e.write(new byte[2]);
        try {
            if (this.l != null && !this.l.isEmpty()) {
                this.e.write(DerCoder.encode((ASN1Object)new CON_SPEC(0, this.l.toASN1Object(), true)));
            }
            if (this.i != null && !this.i.isEmpty()) {
                this.e.write(DerCoder.encode((ASN1Object)new CON_SPEC(1, this.i.toASN1Object(), true)));
            }
            this.e.write(DerCoder.encode((ASN1Object)ASN.createSetOf((Vector)this.b)));
            this.e.write(new byte[2]);
            if (this.d) {
                this.e.close();
                return;
            }
        }
        catch (CodingException codingException) {
            throw new IOException(codingException.toString());
        }
    }

    private void a() {
        this.a = 1;
        if (this.l.containsOtherCertificates() || this.i.containsOtherRevocationInfos()) {
            this.a = 5;
            return;
        }
        int n2 = this.l.getAttributeCertificateType();
        if (n2 == 1) {
            this.a = 3;
        } else if (n2 == 2) {
            this.a = 4;
        }
        if (this.a < 3) {
            Enumeration enumeration = this.b.elements();
            while (enumeration.hasMoreElements()) {
                if (((SignerInfo)enumeration.nextElement()).getVersion() != 3) continue;
                this.a = 3;
                break;
            }
        }
        if (this.a < 3 && !this.j.equals((Object)ObjectID.cms_data)) {
            this.a = 3;
        }
    }

    public void addSignerInfo(SignerInfo signerInfo) throws NoSuchAlgorithmException {
        boolean bl;
        signerInfo.a(this);
        if (signerInfo.getSecurityProvider() == null) {
            signerInfo.setSecurityProvider(this.c);
        }
        AlgorithmID algorithmID = signerInfo.getDigestAlgorithm();
        boolean bl2 = signerInfo.getSignatureValue() == null;
        boolean bl3 = bl = this.g.a(algorithmID, bl2) && bl2;
        if (bl) {
            this.k = this.g.a(this.k, false);
        }
        this.b.addElement(signerInfo);
        if (this.a < 3 && signerInfo.getVersion() == 3) {
            this.a = 3;
        }
    }

    public void addCertificates(Certificate[] certificateArray) {
        if (certificateArray != null && certificateArray.length > 0) {
            this.l.addCertificates(certificateArray);
            this.a();
        }
    }

    public void addCRLs(X509CRL[] x509CRLArray) {
        if (x509CRLArray != null && x509CRLArray.length > 0) {
            this.i.addRevocationInfos((CRL[])x509CRLArray);
            this.a();
        }
    }

    public SignedDataOutputStream(OutputStream outputStream, ObjectID objectID, int n2, SecurityProvider securityProvider) {
        this();
        if (outputStream == null) {
            throw new NullPointerException("Output stream must not be null!");
        }
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Illegal mode specification: " + n2 + "! Expected " + 1 + " (implicit) or " + 2 + " (explicit)");
        }
        this.j = objectID;
        this.e = outputStream;
        this.k = n2 == 1 ? new DataOutputStream(outputStream, false) : new v();
        this.f = n2;
        if (!this.j.equals((Object)ObjectID.cms_data)) {
            this.a = 3;
        }
        this.c = securityProvider;
    }

    public SignedDataOutputStream(OutputStream outputStream, ObjectID objectID, int n2) {
        this(outputStream, objectID, n2, null);
    }

    public SignedDataOutputStream(OutputStream outputStream, int n2) {
        this(outputStream, ObjectID.cms_data, n2, null);
    }

    private SignedDataOutputStream() {
        this.b = new Vector();
        this.l = new CertificateSet();
        this.i = new RevocationInfoChoices();
    }
}

